package com.tandbergtv.neptune.ui.realm.client.networkelements.view;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.ui.framework.client.application.TimedEvent;
import com.tandbergtv.neptune.ui.framework.client.application.TimedEventHandler;
import com.tandbergtv.neptune.ui.realm.client.RealmUIEvents;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIService;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.UiNetworkElement;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

/**
 * 		Portlet that displays the HAS status overview
 * 
 * @author Francisco Bento da Silva Neto
 *
 */
public class ClusterStatusPortlet extends Portlet implements DocumentAttachHandler, DocumentDetachHandler, TimedEventHandler {
		
	private RealmConstants constants = GWT.create(RealmConstants.class);

	/* The RPC service */
	private final INetworkElementsUIServiceAsync service = GWT.create(INetworkElementsUIService.class);
	
	// Panel that shows the redundancy status + description
	protected RedundancyStatusPanel redundancyStatusPanel;
	
	// Table for showing the cluster status
	private FlexTableContainer table;

	private HandlerRegistration timerEventHandler;

	public ClusterStatusPortlet() {
        super("CLUSTER_STATUS");
        initializeWidget();
	}

	private void initializeWidget() {
		setTitle(constants.clusterStatusPortletHeader());
		setDisplayName(constants.clusterStatusPortletHeader());

		redundancyStatusPanel = new RedundancyStatusPanel();
		add(redundancyStatusPanel);

		table = new FlexTableContainer();
		table.setCellSpacing(0);
		table.setStyleName("portletTable");
		table.setWidth("100%");
		add(table);

		addDocumentAttachHandler(this);
		addDocumentDetachHandler(this);
	}

	private void reload() {
		service.getClusterElementsStatus(new NeptuneAsyncCallback<List<UiNetworkElement>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				// do nothing, keep last state
			}

			@Override
			public void onNeptuneSuccess(List<UiNetworkElement> networkElements) {
				clearTableData();
				if (!networkElements.isEmpty()) {
					prepareTableHeader();
	
					populateTableData(networkElements);
				}
				update();
			}

		});

	}

	private void prepareTableHeader() {
		// add status column header first	
		table.setWidget(0, 0, new LabelWidget(constants.nodeStatus()));
		table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");

		table.setWidget(0, 1, new LabelWidget(constants.nodeName()));
		table.getCellFormatter().setStyleName(0, 1, "portlet-tableHeader");

		table.setWidget(0, 2, new LabelWidget(constants.nodeMode()));
		table.getCellFormatter().setStyleName(0, 2, "portlet-tableHeader");

		table.setWidget(0, 3, new LabelWidget(constants.nodeIP()));
		table.getCellFormatter().setStyleName(0, 3, "portlet-tableHeader");

	}

	private void populateTableData(List<UiNetworkElement> networkElements) {
		int dataRow = 1;
		for (UiNetworkElement ne : networkElements) {
			populateRowData(dataRow, ne);
			dataRow++;
		}
	}

	private void clearTableData() {
		table.removeAllRows();
	}

	private void populateRowData(int row, UiNetworkElement ne) {
		ImageWidget image = new ImageWidget("realm/images/icon_circ_" + ne.getStatus().name() + ".png");
		image.setTitle(ne.getStatus().name());
		table.setWidget(row, 0, image);
		table.getCellFormatter().setStyleName(row, 0, "portlet-table-icons");
		
		table.setWidget(row, 1, new LabelWidget(ne.getName()));
		table.getCellFormatter().setStyleName(row, 1, "portlet-table-text");

		table.setWidget(row, 2, new LabelWidget(ne.getMode()));
		table.getCellFormatter().setStyleName(row, 2, "portlet-table-text");
		
		table.setWidget(row, 3, new LabelWidget(ne.getIp()));
		table.getCellFormatter().setStyleName(row, 3, "portlet-table-text");
	}
	
	/**
	 * 		Timer has elapsed, refresh the UI
	 */
	@Override
	public void onTimerElapsed(TimedEvent authenticationEvent) {
		reload();
	}
	
	@Override
	public void onAttach(DocumentAttachEvent event) {
		// Subscribes to the Neptune's timer event to refresh the portlet every N seconds
		timerEventHandler = RealmUIEvents.EVENT_BUS.addHandler(TimedEvent.TYPE, this);
		redundancyStatusPanel.refreshState();
		reload();
	}

	@Override
	public void onDetach(DocumentDetachEvent event) {
		// Unsubscribe the timer event
		timerEventHandler.removeHandler();
		redundancyStatusPanel.unHookListeners();
	}

}
