package com.tandbergtv.neptune.ui.framework.client.impl;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;

public class ServiceLoaderImpl implements ServiceLoader {
	private final List<Component> components;
	
	public ServiceLoaderImpl(List<Component> components)
	{
		this.components = components;
	}
	
	public <E extends Service> List<E> loadServices(
			Class<E> serviceInterface) {
		List<E> services = new ArrayList<E>();
		for (Component component : components) {
			List<E> serviceList = component.listServices(serviceInterface,
					ClientAuthorizationManager.getSecurity());
			if (serviceList != null)
				services.addAll(serviceList);
		}
		return services;
	}
}
