package com.tandbergtv.neptune.ui.realm.client.settings.view;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiFloatSetting;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;

public class FloatInputWidgetWrapper implements SettingsInputWidgetWrapper {
	
	protected TextBoxWidget widget = null;
	private UiFloatSetting setting;
	private String initialValue;
	private String settingName;
	
	@Override
	public Widget createInputWidget() {
		widget = new TextBoxWidget();
		widget.setWidth("100px");			

		widget.setName(setting.getName());
		if (initialValue != null && !initialValue.isEmpty()) {
			widget.setValue(initialValue);	
		}
		widget.setTitle(setting.getName());
		
		return widget;
	}
	
	@Override
	public String getValue() {
		return widget.getValue();
	}
	
	@Override
	public String getSettingName() {
		if (settingName == null) {
			return setting.getName();
		} else {
			return settingName;
		}
	}
	
	@Override
	public void setSettingName(String name) {
		this.settingName = name;
		if (widget != null) {
			widget.setTitle(name);
		}
	}
	@Override
	public SettingsInputWidgetWrapper newInstance() {
		return new FloatInputWidgetWrapper();
	}

	@Override
	public void setInitialValue(String initialValue) {
		this.initialValue = initialValue;
	}

	@Override
	public void setSettingDefinition(UiSettingDefinition def) {
		this.setting = (UiFloatSetting) def;
	}
	@Override
	public UiSettingDefinition getSettingDefinition() {
		return setting;
	}

}
