package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import java.util.Map;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;

public class IFrameView extends LazyView {
	private String defaultURL;
	private Frame widget = null;

	public IFrameView(String defaultURL) {
		this.defaultURL = defaultURL;
	}
	
	public void setUrl(String url) {
		this.defaultURL = url;
		if (this.widget != null) {
			this.widget.setUrl(url);			
		}
	}

	@Override
	public String getAnchor() {
		String url = (widget != null) ? widget.getUrl() : null;
		return (url != null && !url.isEmpty()) ? "URL=" + URL.encode(url) : "";
	}

	@Override
	protected void setWidgetAnchor(String anchor) {
		String url = null;
		if (anchor != null && !anchor.isEmpty()) {
			AnchorTokenizer tokenizer = new AnchorTokenizer();
			Map<String, String> tokens = tokenizer.parseAnchor(anchor);
			url = tokens.get("URL");
		}

		if (url == null || url.isEmpty()) {
			if (anchor == null || anchor.trim().isEmpty()) {
				url = this.defaultURL;
			} else {
				url = this.defaultURL + "." + anchor;
			}
		} else {
			url = URL.decode(url);
		}

		this.widget.setUrl(url);
	}

	@Override
	protected Widget createWidget() {
		this.widget = new FrameWidget();
		return this.widget;
	}
}
