/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link InlineLabel} widget.
 * 
 * @see com.google.gwt.user.client.ui.InlineLabel
 * @author Vijay Silva
 */
public class InlineLabelWidget extends InlineLabel implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineLabel#InlineLabel()
	 */
	public InlineLabelWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineLabel#InlineLabel(String)
	 */
	public InlineLabelWidget(String text) {
		super(text);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineLabel#InlineLabel(Element)
	 */
	protected InlineLabelWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.InlineLabel#wrap(Element)
	 */
	public static InlineLabelWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		InlineLabelWidget widget = new InlineLabelWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
