package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.SortFeatureImages;

public class SortFeatureHandler<K, R extends Record<K>> extends
        AbstractFeatureHandler<K, R, SortFeature<K, R>> {

	/* State */
	private final SortFeatureImages bundle;

	/* Only one column can be sortable, only one image needs to be maintained */
	private final ImageWidget sortImage;

	/* The anchor tokens added by the sort feature */
	private static final String SORT_ORDER_ANCHOR_TOKEN = "SortOrder";
	private static final String SORT_COLUMN_ANCHOR_TOKEN = "SortColumn";

	/**
	 * Constructor
	 * 
	 * @param table The table
	 * @param sortFeature The sort feature
	 */
	public SortFeatureHandler(InternalTable<K, R> table, SortFeature<K, R> sortFeature) {
		super(table, sortFeature);
		this.bundle = GWT.create(SortFeatureImages.class);
		this.sortImage = new ImageWidget();
	}

	@Override
	public void initialize() {
		/* For each sort enabled column, add a click listener to change the sort column / order */
		for (final Column<?, R> column : getInternalTable().getColumns()) {
			if (getFeature().isColumnSortable(column)) {
				final Label headerLabel = getInternalTable().getHeaderWidgetLabelForColumn(column);
				headerLabel.setStyleName(TableConstants.STYLE_HEADER_SORTABLE_COL_TEXT);
				headerLabel.addClickHandler(new ClickHandler() {
					public void onClick(ClickEvent event) {
						handleColumnHeaderLabelClick(column, event);
					}
				});
			}
		}
		
		/**Code Changes start by Shrikant Roy*/
		final Column<?, R> column = getFeature().getSortColumn();		
		sortImage.addClickHandler(new ClickHandler() {
					public void onClick(ClickEvent event) {
						handleColumnHeaderLabelClick(column, event);
					}
				});
		/**Code Changes end by Shrikant Roy*/
	}

	@Override
	protected void resetView() {
		/* Remove the sort image from its current location */
		sortImage.removeFromParent();
	}

	@Override
	public void refresh() {
		Column<?, R> column = getFeature().getSortColumn();
		SortOrder sortOrder = getFeature().getSortOrder();

		/* There is only one sort image shown, remove from current location and update it */
		sortImage.removeFromParent();
		boolean ascending = (sortOrder == SortOrder.ASCENDING);
		ImageResource resource = ascending ? bundle.ascending() : bundle.descending();
		sortImage.setResource(resource);

		/* Add the image to the correct column */
		if (column != null && sortOrder != null) {
			HorizontalPanel panel = getInternalTable().getHeaderWidgetForColumn(column);
			if (panel != null)
				panel.add(sortImage);
		}
	}

	@Override
	public Map<String, String> getAnchorTokens() {
		Map<String, String> tokenMap = super.getAnchorTokens();

		/* Only if the table is showing the list view, add these anchor tokens */
		if (getInternalTable().isShowingListView()) {
			/* Set the sort order for the anchor */
			if (getFeature().getSortOrder() != null && getFeature().getSortColumn() != null) {
				tokenMap.put(SORT_ORDER_ANCHOR_TOKEN, getFeature().getSortOrder().name());
				tokenMap.put(SORT_COLUMN_ANCHOR_TOKEN, getFeature().getSortColumn().getName());
			}
		}

		return tokenMap;
	}

	@Override
	public void setAnchor(TableAnchor anchor) {
		String order = anchor.getTokens().get(SORT_ORDER_ANCHOR_TOKEN);
		if (!isBlank(order)) {
			try {
				getFeature().setSortOrder(SortOrder.valueOf(order));
			} catch (Exception e) {
			}
		}

		String columnName = anchor.getTokens().get(SORT_COLUMN_ANCHOR_TOKEN);
		Column<?, R> match = null;
		if ((!isBlank(columnName))) {
			for (Column<?, R> currentColumn : getInternalTable().getColumns()) {
				if (getFeature().isColumnSortable(currentColumn)
				        && columnName.equals(currentColumn.getName())) {
					match = currentColumn;
					break;
				}
			}

			if (match != null)
				getFeature().setSortColumn(match);
		}

	}

	// ========================================================================
	// ===================== FEATURE EVENTS BY USER
	// ========================================================================

	/*
	 * Handle the event resulting from clicking a sort enabled column
	 */
	private void handleColumnHeaderLabelClick(Column<?, R> column, ClickEvent event) {
		SortOrder order = getFeature().getDefaultSortOrder();
		if (getFeature().getSortColumn().equals(column)) {
			SortOrder oldOrder = getFeature().getSortOrder();
			order = (oldOrder != SortOrder.ASCENDING) ? SortOrder.ASCENDING : SortOrder.DESCENDING;
		}

		/* Update the sorting information */
		getFeature().setSortColumn(column);
		getFeature().setSortOrder(order);

		fireFeatureEvent(new FeatureEvent());
	}
}
