/*
 * Created on July 23 28, 2012
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.application.event;

import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Widget;

/**
 * Event triggered before the application content widget is about to be changed
 * 
 * @author Vijay Silva
 */
public class BeforeContentChangeEvent extends GwtEvent<BeforeContentChangeHandler> {

	/* The Handler type */
	private static Type<BeforeContentChangeHandler> TYPE;
	private final Widget contentWidget;
	private boolean canceled = false;

	/**
	 * Constructor
	 * 
	 * @param contentWidget The content widget that is about to be removed / replaced
	 */
	public BeforeContentChangeEvent(Widget contentWidget) {
		this.contentWidget = contentWidget;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<BeforeContentChangeHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<BeforeContentChangeHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<BeforeContentChangeHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(BeforeContentChangeHandler handler) {
		handler.onBeforeContentChange(this);
	}

	/**
	 * Get the current content widget
	 * 
	 * @return the content widget
	 */
	public Widget getContentWidget() {
		return contentWidget;
	}

	/**
	 * Cancel the change event forcing the framework to not change the widget
	 */
	public void cancel() {
		this.canceled = true;
	}

	/**
	 * Determine if this event has been canceled
	 * 
	 * @return true if the event is canceled, false otherwise
	 */
	public boolean isCanceled() {
		return this.canceled;
	}
}
