package com.tandbergtv.neptune.widgettoolkit.client.menu;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class GroupMenuItem extends MenuItemBase implements IsSerializable {
	private List<MenuItemBase> subPanels;

	public GroupMenuItem() {
	}
	
	public GroupMenuItem(String name, List<MenuItemBase> subPanels) {
		super(name);
		this.subPanels = subPanels;
	}
	
	public GroupMenuItem(String name, String displayName, List<MenuItemBase> subPanels) {
		super(name, displayName);
		this.subPanels = subPanels;
	}

	public List<MenuItemBase> getSubPanels() {
		return subPanels;
	}
	
	public void setSubPanels(List<MenuItemBase> subPanels) {
		this.subPanels = subPanels;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
