package com.tandbergtv.neptune.widgettoolkit.client.application;

import com.google.gwt.user.client.ui.Widget;


/**
 * Interface that decouples the consumer of a widget from the provider of a widget.
 */
public interface TypedWidgetFactory<T extends Widget> {

	/**
	 * Get the widget associated with this factory
	 * 
	 * @return The widget created / maintained by this factory
	 */
	T getInstance();

	/**
	 * Release the widget resources for the widget previously created by this factory
	 * 
	 * @param widget The widget
	 */
	void release(T widget);
}
