/*
 * Created on Aug 15, 2011
 * 
 * (C) Copyright Ericsson Television Inc.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal;

import java.io.Serializable;
import java.util.Date;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.TimeZone;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Model for the server time.
 * <p>
 * WARNING: DO NOT USE this class directly. This is not part of the Neptune API!
 * </p>
 * 
 * @author Vijay Silva
 */
public class ServerTime implements Serializable, IsSerializable {

	private static final long serialVersionUID = 3188342335151863797L;
	private int timeZoneOffset;
	private long time;
	private String dateString;

	/**
	 * The internal format used for the stored the date string
	 */
	public static final String INTERNAL_DATETIME_PATTERN = "dd-MM-yyyy HH:mm:ss";

	/*
	 * Constructor for GWT serialization
	 */
	protected ServerTime() {
	}

	/**
	 * Create a new server time object using the given time and time zone. Always construct this
	 * class on the server.
	 * 
	 * @param timeZoneOffset The server time zone offset (in minutes)
	 * @param currentTime The current time
	 * @param dateString the date string in the server time zone that matches the
	 *        {@link #INTERNAL_DATETIME_PATTERN}
	 */
	public ServerTime(int timeZoneOffset, Date currentTime, String dateString) {
		super();

		if (GWT.isClient()) {
			throw new RuntimeException("Cannot construct this object on the client.");
		}

		this.time = currentTime.getTime();
		this.timeZoneOffset = timeZoneOffset;
		this.dateString = dateString;
	}

	/**
	 * Copy constructor
	 * 
	 * @param other The server time object to copy
	 */
	public ServerTime(ServerTime other) {
		this.timeZoneOffset = other.timeZoneOffset;
		this.time = other.time;
		this.dateString = other.dateString;
	}

	/**
	 * Get the time as the number of milliseconds since January 1, 1970, 00:00:00 GMT
	 * 
	 * @return The server time
	 */
	public long getTime() {
		return time;
	}

	/**
	 * Get the time zone
	 * 
	 * @return The server time zone
	 */
	public TimeZone getTimeZone() {
		return TimeZone.createTimeZone(this.timeZoneOffset);
	}

	/**
	 * Get the date string
	 * 
	 * @return The date string
	 */
	public String getDateString() {
		return this.dateString;
	}

	/**
	 * Parse the date string into a date object using the default time zone. Does not use the time
	 * since epoch.
	 * 
	 * @return The date
	 */
	public Date getDate() {
		DateTimeFormat format = DateTimeFormat.getFormat(INTERNAL_DATETIME_PATTERN);
		return format.parseStrict(this.dateString);
	}
}
