/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb.dao;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.entity.NetworkElementStatus;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NetworkElementsDAO {
    private Logger logger = Logger.getLogger(NetworkElementsDAO.class);
    protected static final String SCRIPTS_FOLDER = "scripts";
    protected static final String CLUSTER_REDUNDANCY_SCRIPT = "vcscheck.sh";
    protected static final String CLUSTER_ELEMENTS_STATUS_SCRIPT = "cluster_info.sh";

    protected File getScriptsFolder() {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File folder = new File(configReaderService.getInstallDirectory(), SCRIPTS_FOLDER);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkElementStatus getRedundancyStatus() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Fetching cluster redundancy status. ");
        }
        String code = "";
        InputStream in = null;
        File redundancyFile = null;
        try {
            redundancyFile = new File(this.getScriptsFolder(), CLUSTER_REDUNDANCY_SCRIPT);
            if (redundancyFile.exists()) {
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", redundancyFile.getAbsolutePath());
                Process proc = builder.start();
                InputStreamReader is = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(is);
                String lastLine = code = br.readLine();
                while (lastLine != null) {
                    lastLine = br.readLine();
                    if (lastLine == null) continue;
                    code = lastLine;
                }
            } else {
                code = String.valueOf(NetworkElementStatus.DISABLED.getStatusValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error running cluster redundancy script: " + redundancyFile), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        NetworkElementStatus reduncancyStatus = null;
        try {
            int redundancyStatusCode = Integer.parseInt(code);
            reduncancyStatus = NetworkElementStatus.valueOf((int)redundancyStatusCode);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("Cluster redundancy in invalid state: " + code));
        }
        if (reduncancyStatus == null) {
            reduncancyStatus = NetworkElementStatus.FAILED;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cluster redundancy status fetched: " + reduncancyStatus));
        }
        return reduncancyStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkElement> getClusterElementsStatus() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Fetching cluster elements status. ");
        }
        InputStream in = null;
        File clusterStatus = null;
        ArrayList<NetworkElement> networkElements = new ArrayList<NetworkElement>();
        try {
            clusterStatus = new File(this.getScriptsFolder(), CLUSTER_ELEMENTS_STATUS_SCRIPT);
            if (clusterStatus.exists()) {
                ProcessBuilder builder = new ProcessBuilder("sh", "-c", clusterStatus.getAbsolutePath());
                Process proc = builder.start();
                InputStreamReader is = new InputStreamReader(proc.getInputStream());
                BufferedReader br = new BufferedReader(is);
                String line = br.readLine();
                while (line != null) {
                    networkElements.add(this.parseNetworkElement(line));
                    line = br.readLine();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error reading cluster redundancy file: " + clusterStatus), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cluster elements fetched: " + networkElements));
        }
        return networkElements;
    }

    protected NetworkElement parseNetworkElement(String line) {
        String[] split = line.split(",");
        NetworkElement ne = new NetworkElement();
        ne.setStatus(NetworkElementStatus.valueOf((int)Integer.parseInt(split[0])));
        ne.setName(split[1]);
        ne.setMode(split[2]);
        ne.setIp(split[3]);
        return ne;
    }
}

