/*
 * This file is modified from PagePortlet of GWT Portlets.
 *
 * GWT Portlets Framework (http://code.google.com/p/gwtportlets/)
 * Copyright 2009 Business Systems Group (Africa)
 *
 * GWT Portlets is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GWT Portlets is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GWT Portlets.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.tandbergtv.neptune.ui.portalpage.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.event.*;
import org.gwtportlets.portlet.client.layout.*;
import org.gwtportlets.portlet.client.ui.ContainerPortlet;
import org.gwtportlets.portlet.client.ui.LayoutPanel;
import org.gwtportlets.portlet.client.ui.PortletFactory;
import org.gwtportlets.portlet.client.ui.ToolButton;
import org.gwtportlets.portlet.client.util.Rectangle;

/**
 * Displays the current page by listening for {@link PageChangeEvent}'s
 * and swapping out a new tree of widgets in a content area on page changes.
 * If the page is editable then an edit button is displayed that launches
 * the online layout editor on click.
 */
@SuppressWarnings("unchecked")
public class NeptunePortletPage extends ContainerPortlet implements
        BroadcastListener {

	private static int PADDING = 0;
	private static String CONFIGURE_TEXT = "Edit portlet layout";

	private LayoutPanel panel = new LayoutPanel();
    private static ToolButton edit;

    private PageChangeEvent pageChange;

    public NeptunePortletPage() {
        initWidget(panel);
        panel.setLimitMaximize(true);
        setStyleName("portlet-page");
    }

    protected Container getDelegate() {
        return panel;
    }

    private void restore(Factory f) {
    }
    
    private void resetWidgets() {
    	panel.clear();
    }

    public void onBroadcast(Object ev) {
        if (ev instanceof PageChangeEvent) {
            onPageChange((PageChangeEvent)ev);
        }
    }

    @SuppressWarnings("rawtypes")
	protected void onPageChange(PageChangeEvent pageChange) {
        if (pageChange.isHandled()) {
            return;
        }
        pageChange.setHandled(true);
        this.pageChange = pageChange;

        // replace the contents of our panel with a tree of widgets created
        // from the factory in the page
        panel.clear();
        WidgetFactory wf = pageChange.getWidgetFactory();
        if (wf != null) {
            panel.add(LayoutUtil.createWidget(wf), new RowLayout.Constraints(LayoutConstraints.VISIBLE));
        }
        panel.layout();

        // if the page is editable then make sure the edit button is visible
        if (pageChange.isEditable()) {
            if (edit == null) {
                edit = new ToolButton(ToolButton.CONFIGURE, CONFIGURE_TEXT,
                        new ClickHandler() {
                    public void onClick(ClickEvent event) {
                        onEditPage();
                    }
                });
            }
            edit.setTitle(CONFIGURE_TEXT);
            if (!edit.isAttached()) {
                RootPanel.get().add(edit);
                updateEditButtonPosition();
            }
            edit.setVisible(true);
        } else if (edit != null && edit.isAttached()) {
            RootPanel.get().remove(edit);
        }
    }

    private void onEditPage() {
    	panel.getElement().setScrollTop(0);
        pageChange.editPage((Container)panel.getWidget(0));
    }

    public void boundsUpdated() {
        super.boundsUpdated();
        updateEditButtonPosition();
    }

    protected void updateEditButtonPosition() {
        if (edit != null && edit.isAttached()) {
            Rectangle r = new Rectangle();
            r.width = edit.getMaxWidth();
            r.height = edit.getMaxHeight();
            r.x = Window.getClientWidth() - r.width - PADDING;
            r.y = Window.getClientHeight() - r.height - PADDING;
            LDOM.setBounds(edit, r);
        }
    }

    public boolean isConfigureSupported() {
        return true;
    }

    public void configure() {
    }
    
    public static void removeEditButton() {
    	if (edit.isAttached()) {
    		RootPanel.get().remove(edit);
    	}
    }

    @SuppressWarnings("rawtypes")
	public WidgetFactory createWidgetFactory() {
        return new Factory(this);
    }

    public static class Factory extends PortletFactory<NeptunePortletPage> {
		private static final long serialVersionUID = 1L;
		private static NeptunePortletPage portletPage = null;

		public Factory() {
        }

        public Factory(NeptunePortletPage p) {
            super(p);
        	portletPage = p;
        }

        public void refresh(NeptunePortletPage p) {
            super.refresh(p);
            p.restore(this);
        }

        public NeptunePortletPage createWidget() {
        	if (portletPage == null) {
        		portletPage = new NeptunePortletPage();
        	} else {
        		portletPage.resetWidgets();
        	}
            return portletPage;
        }
    }

}


