package com.tandbergtv.neptune.ui.portalpage.client.portaluserpref;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiPortalUserPreference implements IsSerializable {
	private static final long serialVersionUID = 1L;
	private static final String COLUMN_MARKER = "__column__";

	private Long id;
	private String userName;
	private String component;
	private String key;
	private int columnIndex;
	private int rowIndex;
	private float width;
	private float height;
	
	public UiPortalUserPreference() {
		id = -1L;
		userName = "";
		component = "";
		key = "";
		columnIndex = -1;
		rowIndex = -1;
		width = -1;
		height = -1;
	}
	
	// temporary fn to test recreating page from file - change to db
	//  format is "KEY\tCOLUMN\tROW\tWIDTH\tHEIGHT";
	/*
	public UiPortalUserPreference(String fileText) {
		this();
		if (null != fileText && fileText.trim().length() > 0) {
			// POC format is title\tURL
			int delimPos = fileText.indexOf("\t");
			key = fileText.substring(0, delimPos).trim();
			fileText = fileText.substring(delimPos).trim();
			delimPos = fileText.indexOf("\t");
			columnIndex = Integer.parseInt(fileText.substring(0, delimPos).trim());
			fileText = fileText.substring(delimPos).trim();
			delimPos = fileText.indexOf("\t");
			rowIndex = Integer.parseInt(fileText.substring(0, delimPos).trim());
			fileText = fileText.substring(delimPos).trim();
			delimPos = fileText.indexOf("\t");
			width = Float.parseFloat(fileText.substring(0, delimPos).trim());
			height = Float.parseFloat(fileText.substring(delimPos).trim());
		}

	}*/
	
    public Long getId() {
        return id;
    }

    public void setId( Long id ) {
        this.id = id;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName( String userName ) {
        this.userName = userName;
    }

    public String getComponent() {
        return component;
    }

    public void setComponent( String component ) {
        this.component = component;
    }

	public void setKey(String key) {
		this.key = key;
	}
	
	public String getKey() {
		return key;
	}
	
	public void setColumnIndex(int columnIndex) {
		this.columnIndex = columnIndex;
	}
	
	public int getColumnIndex() {
		return columnIndex;
	}
	
	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}
	
	public int getRowIndex() {
		return rowIndex;
	}
	
	public void setWidth(float width) {
		this.width = width;
	}
	
	public float getWidth() {
		return width;
	}
	
	public void setHeight(float height) {
		this.height = height;
	}
	
	public float getHeight() {
		return height;
	}
	
	public void setAsColumnPreference(int columnIndex) {
		component = key = COLUMN_MARKER + Integer.toString(columnIndex);
		this.columnIndex = columnIndex;
		height = -1;
		rowIndex = -1;
	}
	
	public boolean isColumnPreference() {
		return key.startsWith(COLUMN_MARKER) && columnIndex >= 0;
	}
}
