/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ad;

import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.login.LoginException;

public class ActiveDirectoryUserAuthenticationService
implements IUserAuthenticationService {
    private String adUrl;
    private String defaultDomain;

    public ActiveDirectoryUserAuthenticationService(Properties props) {
        this.adUrl = props.getProperty("url");
        if (this.adUrl == null || this.adUrl.isEmpty()) {
            throw new IllegalArgumentException("Missing 'url' configuration parameter.");
        }
        this.defaultDomain = props.getProperty("defaultDomain");
        if (this.defaultDomain == null || this.defaultDomain.isEmpty()) {
            throw new IllegalArgumentException("Missing 'defaultDomain' configuration parameter.");
        }
    }

    public void authenticateUser(String userName, String password, String externalKey) throws LoginException {
        String logon = userName;
        if (externalKey != null && !externalKey.isEmpty()) {
            logon = externalKey;
        }
        if (!this.containsDomain(logon)) {
            logon = logon + "@" + this.defaultDomain;
        }
        this.authenticateAD(logon, password);
    }

    private void authenticateAD(String logon, String password) throws LoginException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.adUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", logon);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (AuthenticationException ex) {
            throw new LoginException("Invalid user name or password. " + ex);
        }
        catch (Exception ex) {
            throw new LoginException("Internal server error. " + ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private boolean containsDomain(String str) {
        if (str == null) {
            return false;
        }
        int idx = str.indexOf(92);
        if (idx > 0) {
            return true;
        }
        idx = str.indexOf(64);
        return idx > 0;
    }

    public Map<String, String> getProperties() {
        return null;
    }

    public void setProperties(Map<String, String> properties) {
    }
}

