package com.tandbergtv.neptune.ui.framework.client;

import java.io.Serializable;

public class UIProductInfo implements Serializable {

	private static final long serialVersionUID = -7445091483007299066L;

	private String productTitle = "";
	private String productSubTitle = "";
	private String productVersion = "";
	private String serverTimePattern = null;

	/* Internal constructor for GWT serialization */
	protected UIProductInfo() {
	}

	public UIProductInfo(String title, String subtitle, String version) {
		this(title, subtitle, version, null);
	}

	public UIProductInfo(String title, String subtitle, String version, String serverTimePattern) {
		this.productTitle = title;
		this.productSubTitle = subtitle;
		this.productVersion = version;
		this.serverTimePattern = serverTimePattern;
	}

	public String getProductTitle() {
		return productTitle;
	}

	public String getProductSubTitle() {
		return productSubTitle;
	}

	public String getProductVersion() {
		return productVersion;
	}

	/**
	 * Get the (optional) server time display pattern.
	 * 
	 * @return The server time display pattern, or null / empty string if default must be used
	 */
	public String getServerTimeDisplayPattern() {
		return this.serverTimePattern;
	}
}
