package com.tandbergtv.neptune.ui.home.client;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * The Add Portlet page responsible for adding portlets to the Home page
 * 
 * @author Daniel Paranhos
 */
public class AddPortletPanel extends VerticalContainer {

	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	private static final String STYLE_VALIDATION_MESSAGE = "realm-validationFailure-message";
	private HomeComponentConstants constants = GWT.create(HomeComponentConstants.class);

	private final Table<String, PortletRecord> table;
	private final PortletDataProvider portletDataProvider;
	private final LabelWidget errorMessageLabel;
	private final HomeTabPanel homeTabPanel;

	/**
	 * Constructor
	 * 
	 * @param homeTabPanel the HomeTabPanel
	 * @param portletFactories the list of all portlet factories
	 */
	public AddPortletPanel(final HomeTabPanel homeTabPanel, List<PortletRecord> portletRecords) {
		this.homeTabPanel = homeTabPanel;

		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		setSpacing(5);

		errorMessageLabel = new LabelWidget();
		errorMessageLabel.setStyleName(STYLE_VALIDATION_MESSAGE);
		add(errorMessageLabel);

		add(new HeaderPanel("Add Portlet"));
		portletDataProvider = new PortletDataProvider(portletRecords);
		table = new Table<String, PortletRecord>(portletDataProvider);
		add(table);

		table.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				errorMessageLabel.setText(constants.couldNotLoadData());
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				showButtons();
				refresh();
			}
		});
	}

	private void showButtons() {
		ButtonWidget addButton = new ButtonWidget();
		addButton.setText(constants.addPortletsAddButton());
		addButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				if (table.getSelectedRecords().size() > 0) {
					homeTabPanel.showPortlets(table.getSelectedRecords());
				} else {
					Window.alert(constants.portletSelectionRequired());
				}
			}
		});

		ButtonWidget backButton = new ButtonWidget();
		backButton.setText(constants.addPortletsBackButton());
		backButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				homeTabPanel.showPortlets(null);
			}
		});

		HorizontalPanel buttonsPanel = new HorizontalPanel();
		buttonsPanel.setSpacing(5);

		buttonsPanel.add(addButton);
		buttonsPanel.add(backButton);

		add(buttonsPanel);
	}

	/*
	 * Refreshes the table data
	 */
	private void refresh() {
		errorMessageLabel.setText(null);
		table.refresh();
	}
}
