package com.tandbergtv.neptune.ui.home.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * The data provider for the Home Portal
 * 
 * @author Daniel Paranhos
 */
public class PortletDataProvider implements DataProvider<String, PortletRecord> {
	private final List<Column<?, PortletRecord>> columns;
	private final ColumnBase<String, PortletRecord> componentColumn;
	private final ColumnBase<String, PortletRecord> titleColumn;
	private final List<PortletRecord> portletRecords;

	/**
	 * Constructor
	 * 
	 * @param portletFactories the list of all portlet factories
	 */
	public PortletDataProvider(List<PortletRecord> portletRecords) {
		this.portletRecords = portletRecords;

		columns = new ArrayList<Column<?, PortletRecord>>();

		componentColumn = new ColumnBase<String, PortletRecord>("component", "Component") {
			public View<String> getView(PortletRecord record) {
				return new LabelStringView(record.getComponentName());
			}
		};
		columns.add(componentColumn);

		titleColumn = new ColumnBase<String, PortletRecord>("title", "Title") {
			public View<String> getView(PortletRecord record) {
				return new LabelStringView(record.getPortlet().getDisplayName());
			}
		};
		columns.add(titleColumn);

	}

	@Override
	public void initialize(final AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public List<Column<?, PortletRecord>> getColumns() {
		return columns;
	}

	@Override
	public void getRecord(String key, final AsyncCallback<PortletRecord> callback) {
		// not needed to implement this method. There is no detail page
		throw new RuntimeException("This operation is not supported.");
	}

	@Override
	public void getRecords(final AsyncCallback<List<PortletRecord>> callback) {
		List<PortletRecord> records = new ArrayList<PortletRecord>(this.portletRecords);
		Collections.sort(this.portletRecords, new Comparator<PortletRecord>() {
			@Override
			public int compare(PortletRecord pr1, PortletRecord pr2) {
				int result = pr1.getComponentName().compareTo(pr2.getComponentName());
				if (result == 0) {
					result = pr1.getPortlet().getDisplayName()
					        .compareTo(pr2.getPortlet().getDisplayName());
				}
				return result;
			}
		});

		callback.onSuccess(records);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return false;
	}
}
