package com.tandbergtv.neptune.ui.home.client;

import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

/**
 * Represents a portlet record for the list page
 * 
 * @author Daniel Paranhos
 */
public class PortletRecord implements Record<String> {
	private final Portlet portlet;
	private final Component component;
	private Integer preferenceIndex = null;

	public PortletRecord(Portlet portlet, Component component) {
		this.portlet = portlet;
		this.component = component;
	}

	public Portlet getPortlet() {
		return portlet;
	}

	public String getKey() {
		return portlet.getPortletId();
	}

	public Component getComponent() {
		return this.component;
	}

	public String getComponentName() {
		return component.getDisplayName();
	}

	public Integer getPreferenceIndex() {
		return preferenceIndex;
	}

	public void setPreferenceIndex(Integer preferenceIndex) {
		this.preferenceIndex = preferenceIndex;
	}
}
