/**
 * 
 */
package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

final class ModulePanel extends Composite {
	private static final String STYLE_TABLE = "role-permissionsTable";
	private static final String STYLE_HEADER_ROW = "role-permissionsTable-header-row";
	private static final String STYLE_HEADER_CELL = "role-permissionsTable-header-cell";
	private static final String STYLE_DATA_ROW = "role-permissionsTable-data-row";
	private static final String STYLE_MODULE_CELL = "role-permissionsTable-module-cell";
	private static final String STYLE_PERMISSION_CELL = "role-permissionsTable-permission-cell";
	
	private FlexTableContainer table;
	private final Map<Long, CheckBoxWidget> map;

	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	public ModulePanel(List<UiModule> model) {
		map = new HashMap<Long, CheckBoxWidget>();
		
		//find maximum permissions count across all modules
		int maxPermissionsCount = 0;
		for(UiModule module : model) {
			int permissionsCount = module.getPermissions().size();
			if(permissionsCount > maxPermissionsCount)
				maxPermissionsCount = permissionsCount;
		}
		
		table = new FlexTableContainer();
		table.setStyleName(STYLE_TABLE);

		int rowCount = 0;
		
		table.setText(rowCount, 0, constants.permissionsTableModuleHeading());
		table.getCellFormatter().setStyleName(rowCount, 0, STYLE_HEADER_CELL);

		table.setText(rowCount, 1, constants.permissionsTablePermissionsHeading());
		table.getFlexCellFormatter().setColSpan(rowCount, 1, maxPermissionsCount);
		table.getCellFormatter().setStyleName(rowCount, 1, STYLE_HEADER_CELL);
		
		table.getRowFormatter().setStyleName(0, STYLE_HEADER_ROW);
		rowCount++;
		
		for (UiModule module : model) {
			table.getRowFormatter().setStyleName(rowCount, STYLE_DATA_ROW);
			
			//add module name cell
			table.setText(rowCount, 0, module.getDisplayName() + ":");
			table.getCellFormatter().setStyleName(rowCount, 0, STYLE_MODULE_CELL);
			
			//add cells for permissions
			int columnCount = 1;
			for (UiPermission permission : module.getPermissions()) {
				CheckBoxWidget checkBox = new CheckBoxWidget(permission.getDisplayName(), false);
				table.setWidget(rowCount, columnCount, checkBox);
				table.getCellFormatter().setStyleName(rowCount, columnCount, STYLE_PERMISSION_CELL);
				map.put(permission.getId(), checkBox);
				columnCount++;
			}
			
			//fill in empty cells
			while(columnCount <= maxPermissionsCount) {
				table.setWidget(rowCount, columnCount, null);
				columnCount++;
			}
				
			rowCount++;
		}
		
		initWidget(table);
	}

	public void setData(Collection<Long> data) {
		// reset to false
		for (CheckBoxWidget checkBox : map.values())
			checkBox.setValue(false);

		// set the checked ones
		for (Long permissionId : data)
			map.get(permissionId).setValue(true);
	}

	public Collection<Long> getData() {
		Collection<Long> checked = new ArrayList<Long>();
		for (Long key : map.keySet())
			if (map.get(key).getValue())
				checked.add(key);
		return checked;
	}

	final class PermissionPanel extends HorizontalPanel {
		private Map<Long, CheckBox> idToCheckBox;

		public PermissionPanel(UiModule module) {
			super.setSpacing(3);
		}

		public Map<Long, CheckBox> getIdToCheckBoxMap() {
			return idToCheckBox;
		}
	}
}
