package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.tab.role.ModuleRecord;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.checkbox.CheckBoxView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.checkbox.MultiCheckBoxView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class ModuleDataProvider implements DataProvider<Long, ModuleRecord> {
	
	private static final String COLUMN_MODNAME_NAME	= "Module Name";
	private static final String COLUMN_VIEW_NAME	= "View";
	private static final String COLUMN_CREATE_NAME	= "Create";
	private static final String COLUMN_MODIFY_NAME	= "Modify";
	private static final String COLUMN_DELETE_NAME	= "Delete";
	private static final String COLUMN_OTHER_NAME	= "Other Permissions";
	
	private static final String COLUMN_MODNAME_STYLE_HEAD	= "mod-name";
	private static final String COLUMN_VIEW_STYLE_HEAD		= "view";
	private static final String COLUMN_CREATE_STYLE_HEAD	= "create";
	private static final String COLUMN_MODIFY_STYLE_HEAD	= "modify";
	private static final String COLUMN_DELETE_STYLE_HEAD	= "delete";
	private static final String COLUMN_OTHER_STYLE_HEAD		= "other";
	
	/*
	private static final String TABLE_STYLE			= "permissions-table";
	private static final String COLUMN_STYLE_HEAD	= "header-row";
	*/
	
	
	private List<Column<?, ModuleRecord>> columns;
	ColumnBase<String, ModuleRecord> columnModuleName;
	ColumnBase<Boolean, ModuleRecord> columnViewPerm;
	ColumnBase<Boolean, ModuleRecord> columnCreatePerm;
	ColumnBase<Boolean, ModuleRecord> columnModifyPerm;
	ColumnBase<Boolean, ModuleRecord> columnDeletePerm;
	ColumnBase<Collection<Boolean>, ModuleRecord> columnOtherPerms;
	
	
	private List<ModuleRecord> records;
	private List<UiModule> uiMods;
	//Map<Long, CheckBoxWidget> checkboxMap;
	//private Table<Long, ModuleRecord> table;
	private ModuleTable view;
	
	private boolean isAscending;

	/*
	public ModuleDataProvider( List<UiModule> uiModules, Map<Long, CheckBoxWidget> checkboxMap, Table<Long, ModuleRecord> table ) {
		uiMods = uiModules;
		this.checkboxMap = checkboxMap;
		this.table = table;
	}
	*/
	public ModuleDataProvider( ModuleTable view, List<UiModule> uiModules ) {
		uiMods = uiModules;
		//this.checkboxMap = checkboxMap;
		//this.table = table;
		this.view = view;
	}
	
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		// TODO Auto-generated method stub
		
//		uiMods.clear();
		
		if( records == null ) {
			records = new ArrayList<ModuleRecord>();
		} else {
			records.clear();
		}
		
		for( UiModule mod : uiMods ) {
			ModuleRecord rec = new ModuleRecord(mod);
			records.add(rec);
		}
		
		initColumns();
		
		if( callback != null ) {
			callback.onSuccess(null);
		}
	}
	
	private void initColumns() {
		if ( columns == null ) {
			columns = new ArrayList<Column<?,ModuleRecord>>();
		} else {
			columns.clear();
		}
		
		view.getCheckBoxMap().clear();			
		
		// module name column
		columnModuleName = new ColumnBase<String, ModuleRecord>( COLUMN_MODNAME_NAME, COLUMN_MODNAME_NAME ) {
			
			@Override
			public View<String> getView(ModuleRecord record) {
				// TODO Auto-generated method stub
				LabelStringView label = new LabelStringView(record.getDisplayName());
				return label;
			}
		};
		columnModuleName.setCellStyle(COLUMN_MODNAME_STYLE_HEAD);
		columns.add(columnModuleName);
		
		
		// view column		
		columnViewPerm = new ColumnBase<Boolean, ModuleRecord>(COLUMN_VIEW_NAME, COLUMN_VIEW_NAME ) {
			
			@Override
			public View<Boolean> getView(ModuleRecord record) {
				CheckBoxView cbView;
				if( record.getViewPerm() == null ) {
					cbView = new CheckBoxView(false, false);
				} else {
					cbView = new CheckBoxView(false);
					view.getCheckBoxMap().put( record.getViewPerm().getId(), cbView.getWidget() );
					//cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( view.getEnabledPermissions() , record.getViewPerm().getId()));
					cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( record.getViewPerm().getId()));
				}
				return cbView;
			}
		};
		columnViewPerm.setCellStyle(COLUMN_VIEW_STYLE_HEAD);
		columns.add(columnViewPerm);
		
		
		// create column
		columnCreatePerm = new ColumnBase<Boolean, ModuleRecord>(COLUMN_CREATE_NAME, COLUMN_CREATE_NAME ) {
			
			@Override
			public View<Boolean> getView(ModuleRecord record) {
				CheckBoxView cbView;
				if( record.getCreatePerm() == null ) {
					cbView = new CheckBoxView(false, false);
				} else {
					cbView = new CheckBoxView(false);
					view.getCheckBoxMap().put( record.getCreatePerm().getId(), cbView.getWidget() );
					//cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( view.getEnabledPermissions() , record.getCreatePerm().getId()));
					cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( record.getCreatePerm().getId()));
				}
				return cbView;
			}
		};
		columnCreatePerm.setCellStyle(COLUMN_CREATE_STYLE_HEAD);
		columns.add(columnCreatePerm);
		
		// modify column
		columnModifyPerm = new ColumnBase<Boolean, ModuleRecord>(COLUMN_MODIFY_NAME, COLUMN_MODIFY_NAME ) {
			
			@Override
			public View<Boolean> getView(ModuleRecord record) {
				CheckBoxView cbView;
				if( record.getModifyPerm() == null ) {
					cbView = new CheckBoxView(false, false);
				} else {
					cbView = new CheckBoxView(false);
					view.getCheckBoxMap().put( record.getModifyPerm().getId(), cbView.getWidget() );
					//cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( view.getEnabledPermissions() , record.getModifyPerm().getId()));
					cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( record.getModifyPerm().getId()));
				}
				return cbView;
			}
		};
		columnModifyPerm.setCellStyle(COLUMN_MODIFY_STYLE_HEAD);
		columns.add(columnModifyPerm);
		
		// delete column
		columnDeletePerm = new ColumnBase<Boolean, ModuleRecord>(COLUMN_DELETE_NAME, COLUMN_DELETE_NAME ) {
			
			@Override
			public View<Boolean> getView(ModuleRecord record) {
				CheckBoxView cbView;
				if( record.getDeletePerm() == null ) {
					cbView = new CheckBoxView(false, false);
				} else {
					cbView = new CheckBoxView(false);
					view.getCheckBoxMap().put( record.getDeletePerm().getId(), cbView.getWidget() );
					//cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( view.getEnabledPermissions() , record.getDeletePerm().getId()));
					cbView.getWidget().addValueChangeHandler( new checkBoxValueChangeHandler( record.getDeletePerm().getId()));
				}
				return cbView;
			}
		};
		columnDeletePerm.setCellStyle(COLUMN_DELETE_STYLE_HEAD);
		columns.add(columnDeletePerm);
		
		
		
		// other perms column
		// TODO - Multi Checkbox View. ... hmmmm
		columnOtherPerms = new ColumnBase<Collection<Boolean>, ModuleRecord>(COLUMN_OTHER_NAME,COLUMN_OTHER_NAME) {
			
			@Override
			public View<Collection<Boolean>> getView(ModuleRecord record) {
				// TODO Auto-generated method stub
				MultiCheckBoxView cbView = new MultiCheckBoxView( new ArrayList<Boolean>() );
				if( record.getOtherPerms() != null ) {
					List<UiPermission> uiPerms = record.getOtherPerms();
					
					Collections.sort(uiPerms, new Comparator<UiPermission>() {
						
						@Override
						public int compare(UiPermission o1, UiPermission o2) {
							return o1.getDisplayName().compareTo(o2.getDisplayName() );
						}
					});
					
					for( UiPermission perm : uiPerms ) {
						CheckBoxWidget cBox = new CheckBoxWidget(perm.getDisplayName());
						view.getCheckBoxMap().put(perm.getId(), cBox );
//						cBox.addValueChangeHandler( new checkBoxValueChangeHandler( view.getEnabledPermissions(), perm.getId() ));
						cBox.addValueChangeHandler( new checkBoxValueChangeHandler( perm.getId() ));
						cbView.addCheckBoxWidget(cBox);
					}
//				} else {
//					return null;
				}
				return cbView;
			}
		};
		columnOtherPerms.setCellStyle(COLUMN_OTHER_STYLE_HEAD);
		columns.add(columnOtherPerms);
		
	}
	
	public void setUiModules( List<UiModule> uiModules ) {
		uiMods = uiModules;
	}
	
	public List<UiModule> getUiModules() {
		return uiMods;
	}
	
	@Override
	public List<Column<?, ModuleRecord>> getColumns() {		
		if( columns == null ) {
			initColumns();
		}
		return columns;
	}

	@Override
	public void getRecords(AsyncCallback<List<ModuleRecord>> callback) {
		
		SortFeature<Long, ModuleRecord> sortFeature = view.getTable().getSortFeature();
		
		if( sortFeature != null ) {
			isAscending = SortOrder.ASCENDING.equals(sortFeature.getSortOrder());
			
			//Column<Long, ModuleRecord> sortCol = (Column<Long, ModuleRecord>) sortFeature.getSortColumn();
			try{
				if( isAscending ) {
					Collections.sort(records, new Comparator<ModuleRecord>() {
	
						@Override
						public int compare(ModuleRecord o1, ModuleRecord o2) {
							return o1.getDisplayName().compareTo(o2.getDisplayName() );
						}
					});
				} else {
					Collections.sort(records, new Comparator<ModuleRecord>() {
	
						@Override
						public int compare(ModuleRecord o1, ModuleRecord o2) {
							return o2.getDisplayName().compareTo(o1.getDisplayName() );
						}
					});
				}
			} catch ( Exception e ) {
				e.printStackTrace();
			}
		}
		
		
		callback.onSuccess(records);
	}

	@Override
	public void getRecord(Long key, AsyncCallback<ModuleRecord> callback) {
		ModuleRecord tempRecord = null;
		
		for( ModuleRecord aRecord : records ) {
			if( aRecord.getKey() == key ) {
				tempRecord = aRecord;
				break;
			}
		}

		callback.onSuccess( tempRecord );
	}

	@Override
	public boolean isRecordCountEnabled() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isCheckboxEnabled() {
		// TODO Auto-generated method stub
		return false;
	}
	
	private class checkBoxValueChangeHandler implements ValueChangeHandler<Boolean> {
		private Long permission;

		public checkBoxValueChangeHandler ( Long permission ) {
			this.permission = permission;
		}

		@Override
		public void onValueChange(ValueChangeEvent<Boolean> event) {
			if( event.getValue() ) {
				if( ! view.getEnabledPermissions().contains(permission) ) {
					view.getEnabledPermissions().add(permission);
				}
			} else {
				if( view.getEnabledPermissions().contains(permission) ) {
					view.getEnabledPermissions().remove(permission);
				}
			}
		}
		
		
	}
	

}
