/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.view.external;

import com.google.gwt.event.shared.GwtEvent;

/**
 * User Table View event indicating that the user table view has triggered an event
 * 
 * @author Vijay Silva
 */
public class ExternalUserViewEvent extends GwtEvent<ExternalUserViewEventHandler> {

	/* The handler type */
	private final EventType eventType;
	private static Type<ExternalUserViewEventHandler> TYPE;

	/**
	 * Constructor
	 * 
	 * @param eventType The event type
	 */
	public ExternalUserViewEvent(EventType eventType) {
		this.eventType = eventType;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ExternalUserViewEventHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ExternalUserViewEventHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ExternalUserViewEventHandler> getAssociatedType() {
		return getType();
	}

	/*
	 * Fire the event
	 */
	@Override
	protected void dispatch(ExternalUserViewEventHandler handler) {
		if (eventType == null)
			return;

		switch (eventType) {
		case SHOW_BLANK:
			handler.onShowBlankWidget(this);
			break;
		case SHOW_TABLE:
			handler.onShowTable(this);
			break;
		case SHOW_EXTERNAL_USER:
			handler.onShowExternalUser(this);
			break;
		}
	}

	/**
	 * The event types
	 */
	static enum EventType {
		SHOW_BLANK, SHOW_TABLE, SHOW_EXTERNAL_USER;
	}
}
