package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.realm.client.RealmComponentPermissions;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleTableProvider.RoleRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public class RoleListPanel extends VerticalContainer {
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	private static final String CONTAINER_PANEL_STYLE_DETAIL = "headerAndTableDetailPanel";

	private NeptuneConstants constants = GWT.create(NeptuneConstants.class);
	private RoleTableProvider tableProvider;
	private ResizableContainer resizableContainer = null;
	
	//Buttons
	private ButtonWidget btnCreate;
	private ButtonWidget btnDelete;
	private ButtonWidget btnSave;
	private ButtonWidget btnCancel;
	
	private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
	private static final String USER_IMAGE_URL = "neptune_framework/images/ico_admin.png";


	public RoleListPanel() {
		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		
		final HeaderPanel header = new HeaderPanel("");
		/*
		 * hack to not show the header when the table is loading
		 * consequence:
		 *  set the header visible again and again during list-detail view change,
		 *  when it is actually visible 
		 */
		header.setVisible(false);
		add(header);

		tableProvider = new RoleTableProvider();
		
		tableProvider.getTable().addTableViewChangeHandler(new TableViewChangeHandler<UiRoleKey, RoleTableProvider.RoleRecord>() {
			@Override
			public void onShowDetailView(
					TableDetailViewEvent<UiRoleKey, RoleRecord> event) {
				setStyleName(CONTAINER_PANEL_STYLE_DETAIL);
				if(event.isCreateView())
					header.setLabel(constants.createRoleHeading());
				else
					header.setLabel(constants.viewEditRoleHeading()
							+ " " + event.getRecord().getRole().getName());
				header.setVisible(true);
				updateButtonsForDetailView(tableProvider.getRoleDetailFeature().getRecordDetailView().isSaveAllowed(),
										   event.getRecord());
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				setStyleName(CONTAINER_PANEL_STYLE_LIST);
				header.setLabel(constants.listRolesHeading());
				
				Image image=new Image(USER_IMAGE_URL);
				image.setStyleName(STYLE_HEADER_IMAGE);
			 
				header.setImage(image);
				
				header.setVisible(true);
				refresh();
				updateButtonsForListView();
			}});
			
			
		//resizableContainer = new ResizableContainer(tableProvider.getTable(),constants.roleTab(), null); /* Modified for ECMS  */
		resizableContainer = new ResizableContainer(tableProvider.getTable(),null, null);
		//resizableContainer.getMessageArea().setVisible(false);
		resizableContainer.setWidth("100%");
		resizableContainer.addHeightOffsettingWidget(header);
		
		// Create Button
		btnCreate = new ButtonWidget(constants.createRole());
		btnCreate.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		btnCreate.setStyleName(TableConstants.STYLE_ADD_BUTTON);   /* Added for ECMS */
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.ROLE_CREATE)) {
			btnCreate.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					resizableContainer.reset();
					tableProvider.getTable().showCreateView();
				}
			});
		} 
		btnCreate.setVisible(false);
	
		resizableContainer.addButton(constants.roleTab(), btnCreate);

		// Save Button
		btnSave = new ButtonWidget(constants.saveRole());
		btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		btnSave.setStyleName(TableConstants.STYLE_ADD_BUTTON);
		btnSave.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				tableProvider.getRoleDetailFeature().getRoleRecordDetailView().setListViewContainer(resizableContainer);
				tableProvider.getRoleDetailFeature().getRoleRecordDetailView().save();
			}
		});
		btnSave.setVisible(false);
		resizableContainer.addButton(constants.roleTab(), btnSave);
		
		// Cancel Button
		btnCancel = new ButtonWidget(constants.cancel());
		btnCancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		btnCancel.setStyleName(TableConstants.STYLE_REMOVE_BUTTON);
		btnCancel.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				tableProvider.getRoleDetailFeature().getRoleRecordDetailView().cancel();
				resizableContainer.reset();
			}
		});				
				
		btnCancel.setVisible(false);
		resizableContainer.addButton(constants.roleTab(), btnCancel);
		
		// Delete button
		btnDelete = new ButtonWidget(constants.deleteRole());
		btnDelete.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		btnDelete.setStyleName(TableConstants.STYLE_REMOVE_BUTTON);   /* Added for ECMS */

		btnDelete.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				tableProvider.getRoleDetailFeature().delete(tableProvider.getTable().getSelectedRecords(), new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						resizableContainer.setErrorHTML(caught.getMessage());
					}

					@Override
					public void onNeptuneSuccess(Void result) {
						tableProvider.getTable().refresh();
					}
				});
			}
		});
		btnDelete.setVisible(false);
		resizableContainer.addButton(constants.roleTab(), btnDelete);
		add(resizableContainer);
		
		
	}

	
	public RoleTableProvider getTableProvider() {
		return tableProvider;
	}

	public void setTableProvider(RoleTableProvider tableProvider) {
		this.tableProvider = tableProvider;
	}
	
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeListener) {
		tableProvider.setAnchorChangeNotifier(anchorChangeListener);
	}
	
	private void showCreateButton() {
	    btnCreate.setVisible(ClientAuthorizationManager.isAuthorized( RealmComponentPermissions.ROLE_CREATE));
	}
	
	private void showDeleteButton() {
		btnDelete.setVisible(ClientAuthorizationManager.isAuthorized( RealmComponentPermissions.ROLE_DELETE));
	}
	
	private void showSaveButton(boolean canSave, RoleRecord roleRecord) {
		boolean hasKey = roleRecord.getKey().isValueAssigned();
		String permission = (hasKey) ? RealmComponentPermissions.ROLE_MODIFY
		        					 : RealmComponentPermissions.ROLE_CREATE;
	    btnSave.setVisible(canSave && ClientAuthorizationManager.isAuthorized(permission));
	}
	
	private void updateButtonsForListView(){
		showCreateButton();
		showDeleteButton();
		btnSave.setVisible(false);
		btnCancel.setVisible(false);
	}
	private void updateButtonsForDetailView(boolean canSave, RoleRecord roleRecord){
		btnCreate.setVisible(false);
		showSaveButton(canSave, roleRecord);
		btnCancel.setVisible(true);
		btnDelete.setVisible(false);
	}
	
	public void refresh(){
		if(resizableContainer != null){
			Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand() {
				
				@Override
				public void execute() {
					resizableContainer.updateSize();
					
				}
			});
		resizableContainer.reset();
		}
	}
}
