/*
 * Created on May 5, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event indicating that the view anchor has changed
 * 
 * @author Vijay Silva
 */
public class ViewAnchorChangeEvent extends GwtEvent<ViewAnchorChangeHandler> {

	/* The Handler type */
	private static Type<ViewAnchorChangeHandler> TYPE;

	/* The view anchor */
	private String anchor;

	/**
	 * Constructor
	 * 
	 * @param anchor The anchor
	 */
	public ViewAnchorChangeEvent(String anchor) {
		this.anchor = anchor;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ViewAnchorChangeHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ViewAnchorChangeHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ViewAnchorChangeHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ViewAnchorChangeHandler handler) {
		handler.onAnchorChange(this);
	}

	/**
	 * @return The updated anchor
	 */
	public String getAnchor() {
		return anchor;
	}
}
