/*
 * Created on Oct 29, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter;

import java.util.Date;

/**
 * Converts a String representation of a date object into a different display string representation
 * of the date object. Also provides methods to convert the different string representations to the
 * date object and vice versa.
 * 
 * @author Vijay Silva
 */
public interface IDateConverter extends IValueConverter<String> {

	/**
	 * Get the date pattern used for input value
	 * 
	 * @return the date pattern
	 */
	public String getInputFormat();

	/**
	 * Get the date pattern used for display value
	 * 
	 * @return the date pattern
	 */
	public String getDisplayFormat();

	/**
	 * Get the date for the input value (as required by the model)
	 * 
	 * @return the date
	 */
	public Date getDateForInputValue(String value) throws ValueFormatException;

	/**
	 * Get the date for the display value
	 * 
	 * @return the date
	 */
	public Date getDateForDisplayValue(String value) throws ValueFormatException;

	/**
	 * Get the input value (as required by the model) for the date
	 * 
	 * @return the input value
	 */
	public String getInputValue(Date date);

	/**
	 * Get the display value for the date
	 * 
	 * @return the display value
	 */
	public String getDisplayValue(Date date);
}
