package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_RIGHT;


import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Panel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * this panel should be used by pages that want to show a header.
 * 
 * @author vaibhav
 */
public class HeaderPanel extends Composite implements INeptuneWidget {
	private static final String STYLE_HEADER_LABEL = "nwt-HeaderPanel-label";
	private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
	private static final String STYLE_HEADER = "nwt-HeaderPanel";

	private SimpleContainer mainContainer;
	private Panel container;
	private LabelWidget label;
	private ImageWidget image;
	private SimpleContainer imageContainer = new SimpleContainer();

	public HeaderPanel(String label) {
		this(label, null);
	}

	public HeaderPanel(String label, Image image) {  /* Added for ECMS */
		/* Wrap the header panel table in a 'div' to avoid issues with margin on table */  
							
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);

		container = new HorizontalContainer();
		mainContainer.setWidget(container);
		
		this.label = new LabelWidget(label);
		this.label.setStyleName(STYLE_HEADER_LABEL);
		
		container.add(imageContainer);
		container.add(this.label);
				
		this.setStyleName(STYLE_HEADER);
	}

	public void setLabel(String label) {
		this.label.setText(label);
	}
	
	public void setImage(Image image) {
		imageContainer.setWidget(image);
	}
	
	public LabelWidget getLabel(){
		return this.label;
		
	}
}
