/*
 * Created on May 13, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.application;

import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * Manage authorization and security for the currently logged in user. These methods should only be
 * called by the client-side code.
 * 
 * @author Vijay Silva
 */
public class ClientAuthorizationManager {

	/* Cannot instantiate */
	private ClientAuthorizationManager() {
	}

	/**
	 * Determine if the currently logged in user is authorized with all the input permissions.
	 * 
	 * @param permissions The permissions
	 * @return true if the user has all the permissions, false otherwise
	 */
	public static boolean isAuthorized(String... permissions) {
		/* Get the current user security */
		NeptuneSecurity security = getSecurity();
		if (security == null) {
			return false;
		}

		/* Check if the user has all the required permissions */
		for (String permission : permissions) {
			if (!security.isUserInRole(permission)) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Get the security for the currently logged in user
	 * 
	 * @return The Neptune Security
	 */
	public static NeptuneSecurity getSecurity() {
		return NeptuneApplication.getApplication().getSecurity();
	}
}
