package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view;

/**
 * Provides value caching mechanism to all subclasses. 
 */
public abstract class ViewBase<A> implements View<A> {
	private A value;
	private String styleName;

	public ViewBase(A value) {
		this.value = value;
		preInitialValueSet();
		setViewValue(value);
	}

	public final void commit() {
		value = getViewValue();
	}

	public final void reload() {
		setViewValue(value);
	}

	public String getStyleName() {
	    return styleName;
	}
	
	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}
	
	protected abstract A getViewValue();

	protected abstract void setViewValue(A value);
	
	protected abstract void preInitialValueSet();
}
