/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Hyperlink;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Hyperlink} widget.
 * 
 * @see com.google.gwt.user.client.ui.Hyperlink
 * @author Vijay Silva
 */
public class HyperlinkWidget extends Hyperlink implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hyperlink#Hyperlink()
	 */
	public HyperlinkWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hyperlink#Hyperlink(String, String)
	 */
	public HyperlinkWidget(String text, String targetHistoryToken) {
		super(text, targetHistoryToken);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hyperlink#Hyperlink(String, boolean, String)
	 */
	public HyperlinkWidget(String text, boolean asHTML, String targetHistoryToken) {
		super(text, asHTML, targetHistoryToken);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hyperlink#Hyperlink(Element)
	 */
	protected HyperlinkWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
