/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authorization.ejb;

import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IInternalModuleSynchronizer;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.persist.Module;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Stateless
public class ModuleSynchronizer
implements IInternalModuleSynchronizer {
    private static final Logger logger = Logger.getLogger(ModuleSynchronizer.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("\\p{Alnum}+");
    private static final String NEW_LINE = System.getProperty("line.separator");
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    @EJB
    private IRealmConfigurationService realmConfiguration;
    @EJB
    private IRoleManager roleManager;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void synchronize() {
        Map<String, List<ComponentModule>> moduleMap = this.buildComponentModuleMap();
        Map<String, IModule> applicationModules = this.getComponentModules(moduleMap);
        Map<String, Module> persistedModules = this.getPersistedModules(null);
        for (String moduleName : applicationModules.keySet()) {
            IModule applicationModule = applicationModules.get(moduleName);
            Module persistedModule = persistedModules.get(moduleName);
            this.synchronizeModule(null, applicationModule, persistedModule);
        }
        for (String moduleName : persistedModules.keySet()) {
            if (applicationModules.containsKey(moduleName)) continue;
            Module persistedModule = persistedModules.get(moduleName);
            this.synchronizeModule(null, null, persistedModule);
        }
    }

    public void synchronize(Long componentId, IModuleProvider moduleProvider) {
        Map<String, List<ComponentModule>> moduleMap = this.buildComponentModuleMap(moduleProvider);
        Map<String, IModule> applicationModules = this.getComponentModules(moduleMap);
        Map<String, Module> persistedModules = this.getPersistedModules(componentId);
        for (String moduleName : applicationModules.keySet()) {
            IModule applicationModule = applicationModules.get(moduleName);
            Module persistedModule = persistedModules.get(moduleName);
            this.synchronizeModule(componentId, applicationModule, persistedModule);
        }
        for (String moduleName : persistedModules.keySet()) {
            if (applicationModules.containsKey(moduleName)) continue;
            Module persistedModule = persistedModules.get(moduleName);
            this.synchronizeModule(componentId, null, persistedModule);
        }
    }

    public void updateAdministratorRoles() {
        List<RoleKey> roleKeys = this.realmConfiguration.getAdministratorRoleKeys();
        for (RoleKey roleKey : roleKeys) {
            try {
                this.roleManager.assignAllPermissions(roleKey);
            }
            catch (Exception e) {
                String msg = "Failed to update administrator role[" + roleKey + "] with all permissions, error: " + e.getLocalizedMessage();
                throw new RuntimeException(msg, e);
            }
        }
    }

    private void synchronizeModule(Long componentId, IModule componentModule, Module persistedModule) {
        if (componentModule == null && persistedModule == null) {
            return;
        }
        if (componentModule == null) {
            for (Permission persistedPermission : persistedModule.getPermissions()) {
                this.deletePermission(persistedPermission);
            }
            this.entityManager.remove((Object)persistedModule);
        } else {
            if (persistedModule == null) {
                persistedModule = new Module();
            }
            persistedModule.setName(componentModule.getName());
            persistedModule.setDisplayName(componentModule.getDisplayName());
            persistedModule.setComponentId(componentId);
            if (persistedModule.getId() == null) {
                this.entityManager.persist((Object)persistedModule);
            }
            Map<String, IPermission> modulePermissions = this.getPermissions(componentModule);
            Map<String, Permission> persistedPermissions = this.getPermissions(persistedModule);
            for (String permissionName : persistedPermissions.keySet()) {
                if (modulePermissions.containsKey(permissionName)) continue;
                this.deletePermission(persistedPermissions.get(permissionName));
            }
            persistedModule.removeAllPermissions();
            for (IPermission permission : componentModule.getPermissions()) {
                Permission persistedPermission = persistedPermissions.get(permission.getName());
                this.persistPermission(persistedModule, permission, persistedPermission);
            }
        }
    }

    private Map<String, IPermission> getPermissions(IModule module) {
        HashMap<String, IPermission> permissionMap = new HashMap<String, IPermission>();
        for (IPermission permission : module.getPermissions()) {
            permissionMap.put(permission.getName(), permission);
        }
        return permissionMap;
    }

    private Map<String, Permission> getPermissions(Module module) {
        HashMap<String, Permission> permissionMap = new HashMap<String, Permission>();
        for (Permission permission : module.getPermissions()) {
            permissionMap.put(permission.getName(), permission);
        }
        return permissionMap;
    }

    private void persistPermission(Module parent, IPermission modulePermission, Permission persistedPermission) {
        if (persistedPermission == null) {
            persistedPermission = new Permission();
        }
        persistedPermission.setName(modulePermission.getName());
        persistedPermission.setDisplayName(modulePermission.getDisplayName());
        parent.addPermission(persistedPermission);
    }

    private void deletePermission(Permission permission) {
        Query query = this.entityManager.createNamedQuery("Role.FindByPermissionId");
        query.setParameter("permissionId", (Object)permission.getId());
        List roles = query.getResultList();
        for (Object roleObject : roles) {
            ((Role)roleObject).getPermissions().remove(permission);
        }
        permission.getModule().removePermission(permission);
    }

    private Map<String, Module> getPersistedModules(Long componentId) {
        Query query;
        HashMap<String, Module> moduleMap = new HashMap<String, Module>();
        if (null == componentId) {
            query = this.entityManager.createNamedQuery("Module.FindAllInternal");
        } else {
            query = this.entityManager.createNamedQuery("Module.FindAllByComponentId");
            query.setParameter("componentId", (Object)componentId);
        }
        List modules = query.getResultList();
        if (modules != null) {
            for (Object moduleObject : modules) {
                Module module = (Module)moduleObject;
                moduleMap.put(module.getName(), module);
            }
        }
        return moduleMap;
    }

    private Map<String, IModule> getComponentModules(Map<String, List<ComponentModule>> moduleMap) {
        this.discardInvalidModules(moduleMap);
        HashMap<String, IModule> validModuleMap = new HashMap<String, IModule>();
        for (String moduleName : moduleMap.keySet()) {
            List<ComponentModule> componentModules = moduleMap.get(moduleName);
            validModuleMap.put(moduleName, componentModules.get(0).module);
        }
        return validModuleMap;
    }

    private Map<String, List<ComponentModule>> buildComponentModuleMap() {
        HashMap<String, List<ComponentModule>> moduleMap = new HashMap<String, List<ComponentModule>>();
        ServiceLoader<IModuleProvider> providerLoader = ServiceLoader.load(IModuleProvider.class);
        for (IModuleProvider moduleProvider : providerLoader) {
            Collection providedModules = moduleProvider.getModules();
            if (providedModules == null) continue;
            for (IModule module : providedModules) {
                String moduleName = module.getName();
                ComponentModule componentModule = new ComponentModule(moduleProvider, module);
                ArrayList<ComponentModule> componentModules = (ArrayList<ComponentModule>)moduleMap.get(moduleName);
                if (componentModules == null) {
                    componentModules = new ArrayList<ComponentModule>();
                    moduleMap.put(moduleName, componentModules);
                }
                componentModules.add(componentModule);
            }
        }
        return moduleMap;
    }

    private Map<String, List<ComponentModule>> buildComponentModuleMap(IModuleProvider moduleProvider) {
        HashMap<String, List<ComponentModule>> moduleMap = new HashMap<String, List<ComponentModule>>();
        Collection providedModules = moduleProvider.getModules();
        if (providedModules != null) {
            for (IModule module : providedModules) {
                String moduleName = module.getName();
                ComponentModule componentModule = new ComponentModule(moduleProvider, module);
                ArrayList<ComponentModule> componentModules = (ArrayList<ComponentModule>)moduleMap.get(moduleName);
                if (componentModules == null) {
                    componentModules = new ArrayList<ComponentModule>();
                    moduleMap.put(moduleName, componentModules);
                }
                componentModules.add(componentModule);
            }
        }
        return moduleMap;
    }

    private void discardInvalidModules(Map<String, List<ComponentModule>> moduleMap) {
        HashSet<String> invalidModuleNames = new HashSet<String>();
        StringBuilder errorReport = new StringBuilder();
        errorReport.append("Module synchronization error report: ");
        errorReport.append(NEW_LINE);
        for (String moduleName : moduleMap.keySet()) {
            int permissionCount;
            List<ComponentModule> componentModules = moduleMap.get(moduleName);
            if (componentModules.size() > 1) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\tModule[name='").append(moduleName);
                errorReport.append("', providerImpl={");
                boolean first = true;
                for (ComponentModule componentModule : componentModules) {
                    if (first) {
                        first = false;
                    } else {
                        errorReport.append(", ");
                    }
                    errorReport.append(componentModule.moduleProvider.getClass().getName());
                }
                errorReport.append("}] does not have a unique name(");
                errorReport.append(componentModules.size());
                errorReport.append(" duplicates).");
                errorReport.append(NEW_LINE);
                continue;
            }
            if (moduleName == null || !NAME_PATTERN.matcher(moduleName).matches()) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModules.get(0));
                errorReport.append(" does not have a valid name, ");
                errorReport.append("the name must consist of 1 or more alphanumeric characters.");
                errorReport.append(NEW_LINE);
                continue;
            }
            ComponentModule componentModule = componentModules.get(0);
            List permissions = componentModule.module.getPermissions();
            int n = permissionCount = permissions == null ? 0 : permissions.size();
            if (permissionCount == 0) {
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModule);
                errorReport.append(" does not have any permissions.");
                errorReport.append(NEW_LINE);
                continue;
            }
            for (IPermission permission : permissions) {
                String name = permission.getName();
                if (name != null && NAME_PATTERN.matcher(name).matches()) continue;
                invalidModuleNames.add(moduleName);
                errorReport.append("\t").append(componentModule);
                errorReport.append(" contains a permission with invalid name: '");
                errorReport.append(name).append("', ");
                errorReport.append("the name must consist of 1 or more ");
                errorReport.append("alphanumeric characters.");
                errorReport.append(NEW_LINE);
            }
        }
        if (invalidModuleNames.size() > 0) {
            logger.error((Object)errorReport.toString());
            for (String name : invalidModuleNames) {
                moduleMap.remove(name);
            }
        }
    }

    private class ComponentModule {
        private IModuleProvider moduleProvider;
        private IModule module;

        public ComponentModule(IModuleProvider moduleProvider, IModule module) {
            this.moduleProvider = moduleProvider;
            this.module = module;
        }

        public String toString() {
            String desc = "Module[name='" + this.module.getName() + "', providerImpl=" + this.moduleProvider.getClass().getName() + "]";
            return desc;
        }
    }
}

