/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.ejb;

import com.tandbergtv.neptune.settings.ejb.SettingsConfigurationLocator;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;

public class FilesystemSettingsConfigurationLoader
implements SettingsConfigurationLocator {
    private static final String[] SETTINGS_FOLDERS = new String[]{"Settings", "settings"};
    private static final Logger logger = Logger.getLogger(FilesystemSettingsConfigurationLoader.class);
    private String confFolderLocation;

    public FilesystemSettingsConfigurationLoader(String configurationFolder) {
        this.confFolderLocation = configurationFolder;
    }

    @Override
    public List<URL> findSettingsConfigurations() {
        List<URL> settingsList = null;
        File settingsFolder = null;
        for (String folder : SETTINGS_FOLDERS) {
            try {
                settingsFolder = new File(this.confFolderLocation, folder);
                if (!settingsFolder.exists()) continue;
                IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"neptuneSettings.xml", (IOCase)IOCase.INSENSITIVE);
                Collection settingsFile = FileUtils.listFiles((File)settingsFolder, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.TRUE);
                URL[] configs = FileUtils.toURLs((File[])settingsFile.toArray(new File[0]));
                settingsList = Arrays.asList(configs);
                break;
            }
            catch (Exception e) {
                logger.error((Object)("Error while loading components settings under: " + settingsFolder.getAbsolutePath()));
            }
        }
        if (settingsList == null) {
            settingsList = Collections.emptyList();
            logger.warn((Object)"Settings folder does not exist. ");
        }
        return settingsList;
    }
}

