/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.validation;

import com.tandbergtv.neptune.configuration.settings.entity.BooleanSetting;
import com.tandbergtv.neptune.configuration.settings.entity.EnumerationSetting;
import com.tandbergtv.neptune.configuration.settings.entity.FloatSetting;
import com.tandbergtv.neptune.configuration.settings.entity.IntegerSetting;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.StringSetting;
import com.tandbergtv.neptune.configuration.settings.entity.Validator;
import com.tandbergtv.neptune.configuration.settings.validator.BooleanSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.FloatRangeValidator;
import com.tandbergtv.neptune.configuration.settings.validator.FloatSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.IntegerRangeValidator;
import com.tandbergtv.neptune.configuration.settings.validator.IntegerSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.RequiredSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.StringLengthValidator;
import com.tandbergtv.neptune.configuration.settings.validator.StringPatternValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsValidatorFactory {
    private Map<Class<?>, List<Class<? extends SettingValidator>>> builtInValidators = new HashMap();
    private static SettingsValidatorFactory instance = new SettingsValidatorFactory();

    private SettingsValidatorFactory() {
        this.createValidatorsForString();
        this.createValidatorsForBoolean();
        this.createValidatorsForInteger();
        this.createValidatorsForFloat();
        this.createValidatorsForEnum();
    }

    private List<Class<? extends SettingValidator>> createGenericSettingValidator() {
        ArrayList<Class<? extends SettingValidator>> validators = new ArrayList<Class<? extends SettingValidator>>();
        validators.add(RequiredSettingValidator.class);
        return validators;
    }

    private void createValidatorsForString() {
        ArrayList<Class<Object>> validators = new ArrayList<Class<Object>>();
        validators.addAll(this.createGenericSettingValidator());
        validators.add(StringLengthValidator.class);
        validators.add(StringPatternValidator.class);
        this.builtInValidators.put(StringSetting.class, validators);
    }

    private void createValidatorsForBoolean() {
        ArrayList<Class<Object>> validators = new ArrayList<Class<Object>>();
        validators.addAll(this.createGenericSettingValidator());
        validators.add(BooleanSettingValidator.class);
        this.builtInValidators.put(BooleanSetting.class, validators);
    }

    private void createValidatorsForInteger() {
        ArrayList<Class<Object>> validators = new ArrayList<Class<Object>>();
        validators.addAll(this.createGenericSettingValidator());
        validators.add(IntegerSettingValidator.class);
        validators.add(IntegerRangeValidator.class);
        this.builtInValidators.put(IntegerSetting.class, validators);
    }

    private void createValidatorsForFloat() {
        ArrayList<Class<Object>> validators = new ArrayList<Class<Object>>();
        validators.addAll(this.createGenericSettingValidator());
        validators.add(FloatSettingValidator.class);
        validators.add(FloatRangeValidator.class);
        this.builtInValidators.put(FloatSetting.class, validators);
    }

    private void createValidatorsForEnum() {
        ArrayList<Class<? extends SettingValidator>> validators = new ArrayList<Class<? extends SettingValidator>>();
        validators.addAll(this.createGenericSettingValidator());
        this.builtInValidators.put(EnumerationSetting.class, validators);
    }

    private List<Class<? extends SettingValidator>> createCustomValidators(SettingDefinition definition) throws ClassNotFoundException {
        ArrayList<Class<? extends SettingValidator>> validators = new ArrayList<Class<? extends SettingValidator>>();
        if (definition.getValidators() != null && definition.getValidators().getValidator().size() >= 1) {
            for (Validator validator : definition.getValidators().getValidator()) {
                validators.add(Thread.currentThread().getContextClassLoader().loadClass(validator.getClazz()));
            }
        }
        return validators;
    }

    public static SettingsValidatorFactory getInstance() {
        return instance;
    }

    public List<Class<? extends SettingValidator>> getValidatorsFor(SettingDefinition setting) {
        ArrayList<Class<? extends SettingValidator>> validators = new ArrayList<Class<? extends SettingValidator>>();
        try {
            validators.addAll((Collection<Class<? extends SettingValidator>>)this.builtInValidators.get(setting.getClass()));
            validators.addAll(this.createCustomValidators(setting));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return validators;
    }
}

