/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.ejb;

import com.tandbergtv.neptune.settings.ejb.SettingsConfigurationLocator;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ClasspathSettingsConfigurationLoader
implements SettingsConfigurationLocator {
    private static final Logger logger = Logger.getLogger(ClasspathSettingsConfigurationLoader.class);
    private static final String SETTINGS_XML_PATH = "META-INF/services/neptuneSettings.xml";

    @Override
    public List<URL> findSettingsConfigurations() {
        List<URL> settingsList = Collections.emptyList();
        try {
            Enumeration<URL> settingsEnum = Thread.currentThread().getContextClassLoader().getResources(SETTINGS_XML_PATH);
            settingsList = Collections.list(settingsEnum);
        }
        catch (IOException e) {
            logger.error((Object)"Error while loading components settings under: META-INF/services/neptuneSettings.xml", (Throwable)e);
        }
        return settingsList;
    }
}

