/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.service.IComponentManager;
import com.tandbergtv.neptune.realm.persist.Component;
import com.tandbergtv.neptune.validation.ValidationException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ComponentValidator {
    private final IComponentManager componentManager;
    private static final int NAME_MAX_LENGTH = 100;
    private static final int URL_MAX_LENGTH = 200;

    public ComponentValidator(IComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void validateComponent(Component component) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        this.validateName(component, validationMessages);
        this.validateBaseURL(component, validationMessages);
        this.ensureUniqueness(component, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateName(Component component, List<String> messages) {
        String name = component.getName();
        if (this.isBlank(name)) {
            messages.add("Component Name is required.");
            return;
        }
        if (name.length() > 100) {
            messages.add("Component Name exceeds maximum length of 100");
            return;
        }
    }

    private void validateBaseURL(Component component, List<String> messages) {
        String baseURL = component.getBaseURL();
        if (this.isBlank(baseURL)) {
            messages.add("Component URL is required.");
            return;
        }
        if (baseURL.length() > 200) {
            messages.add("Component URL exceeds maximum length of 200");
            return;
        }
        URL url = null;
        try {
            url = new URL(baseURL);
        }
        catch (MalformedURLException e) {
            messages.add("Component URL is malformed");
            return;
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException e) {
            messages.add("Component URL is not formatted strictly according to RFC2396");
            return;
        }
    }

    private void ensureUniqueness(Component component, List<String> messages) {
        String name = component.getName();
        String baseURL = component.getBaseURL();
        List existingComponents = this.componentManager.getComponents();
        for (Component existingComponent : existingComponents) {
            if (existingComponent.getName().equalsIgnoreCase(name) && !existingComponent.equals((Object)component)) {
                messages.add("Component Name already used by \"" + existingComponent.getName() + "\"");
            }
            if (!existingComponent.getBaseURL().equalsIgnoreCase(baseURL) || existingComponent.equals((Object)component)) continue;
            messages.add("Component URL already used by \"" + existingComponent.getName() + "\"");
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

