/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import com.hazelcast.partition.Partition;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;

public final class Cluster {
    public static boolean owner(Object key) {
        return Cluster.localMember().equals(Cluster.getPartition(key).getOwner());
    }

    public static Partition getPartition(Object key) {
        return Hazelcast.getPartitionService().getPartition(key);
    }

    public static int getPartitionId(Object key) {
        return Cluster.getPartition(key).getPartitionId();
    }

    public static String getMemberName(Object key) {
        return Cluster.getPartition(key).getOwner().toString();
    }

    public static Member localMember() {
        return Hazelcast.getCluster().getLocalMember();
    }

    public static InetSocketAddress localAddress() {
        return Cluster.localMember().getInetSocketAddress();
    }

    public static Member memberForAddress(InetSocketAddress address) {
        for (Member member : Hazelcast.getCluster().getMembers()) {
            if (!member.getInetSocketAddress().equals(address)) continue;
            return member;
        }
        return null;
    }

    public static Set<Member> members() {
        HashSet<Member> members = new HashSet<Member>(Hazelcast.getCluster().getMembers());
        members.remove(Cluster.localMember());
        return members;
    }

    public static boolean memberForAddressExists(InetSocketAddress address) {
        return Cluster.memberForAddress(address) != null;
    }

    public static boolean isLocalMemberAddress(InetSocketAddress address) {
        return Cluster.localMember().getInetSocketAddress().equals(address);
    }

    public static Member masterMember() {
        return (Member)Hazelcast.getCluster().getMembers().iterator().next();
    }

    public static boolean isMaster() {
        return Cluster.masterMember().equals(Cluster.localMember());
    }

    public static boolean isMember(Member member) {
        return Hazelcast.getCluster().getMembers().contains(member);
    }

    public static long generateId(String type) {
        return Hazelcast.getIdGenerator((String)type).newId();
    }
}

