package com.tandbergtv.neptune.ui.portalpage.client.ui;

import java.util.ArrayList;
import java.util.List;

import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.ui.CssButton;
import org.gwtportlets.portlet.client.ui.Dialog;
import org.gwtportlets.portlet.client.util.Rectangle;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.ui.portalpage.client.ArrangementEditor;
import com.tandbergtv.neptune.ui.portalpage.client.PortletConfig;

public class AddGadgetDialog extends Dialog {
    private final ArrangementEditor manager;

    private static final int WIDTH = 200;
    private static final int BUTTON_WIDTH = WIDTH/2-20;
    private static final int ROW_HEIGHT = 20;
    
    private ArrayList<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    private List<PortletConfig> gadgetList;
    private Grid checkBoxGrid;
    CheckBox selectAll;
    
    private ClickHandler cancelClickListener = new ClickHandler() {
        public void onClick(ClickEvent event) {
        	onCancelClick();
        }
    };

    private ClickHandler okClickListener = new ClickHandler() {
        public void onClick(ClickEvent event) {
        	onOkClick();
        }
    };

    public AddGadgetDialog(ArrangementEditor manager) {
        super(false, true);
        this.manager = manager;

        setText("Add Gadget");
        setButtonBarVisible(false);
        setMaximizeVisible(false);
        setCloseVisible(false);

        addStyleName("portlet-ed-control");

		FlowPanel panel = new FlowPanel();

		checkBoxGrid = new Grid();
		checkBoxGrid.setCellPadding(0);
		checkBoxGrid.setCellSpacing(0);
		checkBoxGrid.setBorderWidth(0);
		selectAll = new CheckBox("Select All");
		selectAll.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			public void onValueChange(ValueChangeEvent<Boolean> arg0) {
				for (int i=0; i<checkBoxes.size(); i++) {
					checkBoxes.get(i).setValue(arg0.getValue());
				}
			}			
		});

		panel.add(checkBoxGrid);

    	FlowPanel okCancelPanel = new FlowPanel();
    	okCancelPanel.setPixelSize(WIDTH, ROW_HEIGHT);
        Button btnOk = new CssButton("OK", okClickListener);
    	btnOk.setPixelSize(BUTTON_WIDTH, ROW_HEIGHT);
        okCancelPanel.add(btnOk);
        Button btnCancel = new CssButton("Cancel", cancelClickListener);
    	btnCancel.setPixelSize(BUTTON_WIDTH, ROW_HEIGHT);
        okCancelPanel.add(btnCancel);
        panel.add(okCancelPanel);

    	setWidget(panel);
	}

    /**
     * Sync to our manager and display if not already visible.
     * Limit user editing to level1 (column width) and level2 (row height)
     */
    public void update(List<PortletConfig> list) {
		int numGadgets = list.size();
		checkBoxGrid.clear();
		checkBoxGrid.resize(numGadgets+1, 1);
		checkBoxes.clear();
		gadgetList = list;
		
		selectAll.setValue(false);
		checkBoxGrid.setWidget(0, 0, selectAll);
		checkBoxGrid.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_MIDDLE);
		checkBoxGrid.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
		
    	for (int i=0; i<numGadgets; i++) {
    		CheckBox checkBox = new CheckBox(list.get(i).toString());
    		checkBox.setPixelSize(WIDTH, ROW_HEIGHT);
    		checkBoxGrid.setWidget(i+1, 0, checkBox);
    		checkBoxGrid.getRowFormatter().setVerticalAlign(i+1, HasVerticalAlignment.ALIGN_MIDDLE);
    		checkBoxGrid.getCellFormatter().setHorizontalAlignment(i+1, 0, HasHorizontalAlignment.ALIGN_LEFT);
			checkBoxes.add(checkBox);
    	}
    	setPixelSize(WIDTH*2, (numGadgets+5)*ROW_HEIGHT);
        show();
    }

    public void show() {
    	int height = getOffsetHeight();
        // try to center above or below the root widget
        Rectangle r = LDOM.getBounds(manager.getRoot().getElement());
        int y = r.y - height - 4;
        if (y < 0) { // not enough space above so try below
            y = r.y + r.height + 4;
            if (y + height > Window.getClientHeight()) {
                y = 0; // give up
            }
        }
        int x = r.x + (r.width - WIDTH) / 2;
        if (x < 0) {
            x = 0;
        }
        setPopupPosition(x, y);
        super.show();
    }

    public void onCancelClick() {
    	hide();
    }

    public void onOkClick() {
    	ArrayList<PortletConfig> list = new ArrayList<PortletConfig>();
    	for (int i=0; i<checkBoxes.size(); i++) {
    		if (checkBoxes.get(i).getValue()) {
    			list.add(gadgetList.get(i));
    		}
    	}
    	hide();
    	manager.addGadgets(list);
    }
}
