/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ad;

import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.usermgmt.external.IExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.external.ad.ActiveDirectoryUserAuthenticationService;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ActiveDirectoryUserConfigurationFactory
extends UserConfigurationFactory {
    private static final String CONFIG_FILE_NAME = "ActiveDirectory.properties";
    private static final Logger logger = Logger.getLogger(ActiveDirectoryUserConfigurationFactory.class);
    private boolean createInternalUserAllowed = false;
    private Properties properties;

    public ActiveDirectoryUserConfigurationFactory() {
        this.loadConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        File configDirectory = UserConfigurationFactory.getNeptuneConfigurationDirectory();
        File configFile = new File(configDirectory, CONFIG_FILE_NAME);
        this.properties = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(configFile);
            this.properties.load(reader);
            this.createInternalUserAllowed = "true".equals(this.properties.getProperty("createInternalUserAllowed"));
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load " + configFile), (Throwable)ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {}
        }
    }

    public UserConfigurationMode getUserConfigurationMode() {
        return UserConfigurationMode.Hybrid;
    }

    public boolean allowCreateInternalUser() {
        return this.createInternalUserAllowed;
    }

    public IUserAuthenticationService createUserAuthenticationService() {
        return new ActiveDirectoryUserAuthenticationService(this.properties);
    }

    public IExternalUserProvider createExternalUserProvider() {
        return null;
    }
}

