/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import com.tandbergtv.neptune.realm.persist.ExternalUser;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import com.tandbergtv.neptune.usermgmt.external.IExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapConfigurationManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapContextManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapQuery;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.ProviderConfiguration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;

public class LdapExternalUserProvider
implements IExternalUserProvider {
    private final LdapConfigurationManager configurationManager;
    private final LdapContextManager contextManager;

    public LdapExternalUserProvider(LdapConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.contextManager = new LdapContextManager(this.configurationManager);
    }

    public ExternalUser getUser(String externalKey) {
        if (externalKey == null || externalKey.trim().isEmpty()) {
            throw new IllegalArgumentException("externalKey cannot be blank.");
        }
        ExternalUser user = null;
        LdapContext context = null;
        try {
            context = this.contextManager.openContext();
            user = this.contextManager.get(context, externalKey);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error getting external user from LDAP directory: " + e.getLocalizedMessage(), e);
        }
        finally {
            this.contextManager.closeContext(context);
        }
        return user;
    }

    public SearchResult<ExternalUser> getUsers(SearchMetadata searchMetadata) {
        if (searchMetadata == null) {
            throw new IllegalArgumentException("searchMetadata cannot be null.");
        }
        LdapQuery query = this.getProviderConfiguration().getSearchQueries().getFindAllQuery();
        return this.getUsers(query, searchMetadata, null);
    }

    public SearchResult<ExternalUser> getUsers(String filterCriteria, SearchMetadata searchMetadata) {
        if (filterCriteria == null || filterCriteria.trim().isEmpty()) {
            throw new IllegalArgumentException("filterCriteria cannot be blank.");
        }
        if (searchMetadata == null) {
            throw new IllegalArgumentException("searchMetadata cannot be null.");
        }
        LdapQuery query = this.getProviderConfiguration().getSearchQueries().getFindByCriteriaQuery();
        return this.getUsers(query, searchMetadata, filterCriteria);
    }

    public long getSynchronizationInterval() {
        long interval = this.getProviderConfiguration().getSynchronizationInterval();
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public boolean canSortField(String fieldName) {
        return this.getProviderConfiguration().getSortFieldName().contains(fieldName);
    }

    private ProviderConfiguration getProviderConfiguration() {
        return this.configurationManager.getConfiguration().getProvider();
    }

    private SearchResult<ExternalUser> getUsers(LdapQuery query, SearchMetadata searchMetadata, String criteria) {
        LdapContext context = null;
        try {
            String[] stringArray;
            context = this.contextManager.openContext();
            String baseDN = this.contextManager.getBaseDN(query);
            String filterExpression = query.getFilterExpression();
            if (criteria == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = criteria;
            }
            String[] filterArguments = stringArray;
            SearchControls searchControls = this.contextManager.buildSearchControls(query);
            SearchResult<ExternalUser> searchResult = this.contextManager.search(context, baseDN, filterExpression, filterArguments, searchControls, searchMetadata);
            return searchResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get users from LDAP directory, error: " + e.getLocalizedMessage(), e);
        }
        finally {
            this.contextManager.closeContext(context);
        }
    }
}

