/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OAuthAuthenticationFilter
extends BaseSecurityFilter {
    protected static final String NEPTUNE_SSO_OAUTH2_CLIENT_ID = "neptune_sso_oauth2_client_id";
    protected static final String NEPTUNE_SSO_OAUTH2_CLIENT_SECRET = "neptune_sso_oauth2_client_secret";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_LOGIN_URL = "neptune_sso_oauth2_provider_login_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL = "neptune_sso_oauth2_provider_validate_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_LOGOUT_URL = "neptune_sso_oauth2_provider_logout_url";
    protected static final String NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE = "neptune_sso_oauth2_response_type";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_LOGIN_TOKEN = "access_token";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_TOKEN_TYPE = "token_type";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_USERNAME = "username";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_STATE = "state";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_EXPIRES_IN = "expires_in";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_CLIENT_ID = "client_id";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK = "bookmark";
    private static final List<String> NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS = new ArrayList<String>();
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private static final String DEFAULT_RESPONSE_TYPE = "token";
    private static final String DEFAULT_PROVIDER_VALIDATE_URL = "https://localhost:8443/provider/oauth/validate";
    private static final String URL_PARAM_CLIENT_ID = "client_id";
    private static final String URL_PARAM_CLIENT_SECRET = "client_secret";
    private static final String URL_PARAM_REDIRECT_URL = "redirect_uri";
    private static final String URL_PARAM_RESPONSE_TYPE = "response_type";
    private static final String URL_PARAM_SCOPE = "scope";
    private static final String URL_PARAM_STATE = "state";
    protected String clientId;
    protected String clientSecret;
    protected String providerLoginUrl;
    protected String providerValidateUrl;
    protected String providerLogoutUrl;
    protected String responseType;
    protected AuthProviderClient providerClient;

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
        this.clientSecret = config.getInitParameter(NEPTUNE_SSO_OAUTH2_CLIENT_SECRET);
        this.responseType = this.isEmpty(config.getInitParameter(NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE)) ? DEFAULT_RESPONSE_TYPE : config.getInitParameter(NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE);
        this.clientId = config.getInitParameter(NEPTUNE_SSO_OAUTH2_CLIENT_ID);
        this.providerLoginUrl = this.providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_LOGIN_URL);
        if (this.isEmpty(this.clientId) || this.isEmpty(this.providerLoginUrl)) {
            this.logger.error((Object)"SSO Integration can not work properly. Either a neptune_sso_oauth2_client_id is not provided or neptune_sso_oauth2_provider_login_url is not provided");
            throw new ServletException("SSO Integration can not work properly. Either a neptune_sso_oauth2_client_id is not provided or neptune_sso_oauth2_provider_login_url is not provided");
        }
        this.providerValidateUrl = this.providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL);
        if (this.isEmpty(this.providerValidateUrl)) {
            this.logger.debug((Object)"neptune_sso_oauth2_provider_validate_url is not set. Set it to the default value: https://watchpoint-app:8443/provider/oauth/validate");
            this.providerValidateUrl = DEFAULT_PROVIDER_VALIDATE_URL;
        }
        this.providerLogoutUrl = this.providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_LOGOUT_URL);
        if (this.isEmpty(this.providerLogoutUrl)) {
            this.providerLogoutUrl = "/provider/logout";
            this.logger.debug((Object)("neptune_sso_oauth2_provider_logout_url is not set. Using default value: " + this.providerLogoutUrl));
        }
        this.providerClient = new AuthProviderClient();
        this.providerClient.setValidateUrl(this.providerValidateUrl);
        this.logger.info((Object)("SSO Integration configured with neptune_sso_oauth2_provider_login_url of " + this.providerLoginUrl + " neptune_sso_oauth2_client_id of " + this.clientId + " neptune_sso_oauth2_provider_validate_url " + this.providerValidateUrl + " neptune_sso_oauth2_provider_logout_url " + this.providerLogoutUrl));
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"Neptune OAuth SSO Filter interrupting the request");
        HttpSession session = request.getSession();
        if (this.isLogoutRequested(request, (ServletResponse)response)) {
            this.logoutSSOUser(request, response);
            return;
        }
        if (session == null) {
            this.logger.error((Object)("Could not get user session from request " + request));
            throw new ServletException("Could not get user session from request " + request);
        }
        NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (principal == null) {
            String loginToken = request.getParameter(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_LOGIN_TOKEN);
            if (loginToken == null) {
                this.logger.debug((Object)"User information not found in session or in request, user is not logged in yet, redirecting to provider login page");
                this.redirectUserToProviderLogin(request, response);
                return;
            }
            this.logger.debug((Object)"Token found in request parameters");
            TokenInfo tokenInfo = this.validateTokenWithProvider(request, response, loginToken);
            if (tokenInfo == null || !tokenInfo.isValid()) {
                this.logger.error((Object)("Invalid token found: " + tokenInfo));
                this.logoutSSOUser(request, response);
                return;
            }
            this.logger.debug((Object)"Login succeeded at provider, caching user info");
            principal = new NeptunePrincipal(tokenInfo, loginToken);
            session.setAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL, (Object)principal);
            if (this.redirectUserToOriginalUrl((ServletRequest)request, (ServletResponse)response)) {
                return;
            }
        } else {
            this.logger.debug((Object)"Validating SSO Principal to Continue..");
            if (principal.isExpired()) {
                this.logger.debug((Object)"Going to refresh token with provider");
                this.refreshTokenWithProvider(request, response);
                return;
            }
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected TokenInfo validateTokenWithProvider(HttpServletRequest request, HttpServletResponse response, String loginToken) {
        return this.providerClient.validateToken(loginToken, request);
    }

    private void redirectUserToProviderLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectionUrl = this.buildProviderLoginUrl(request);
        response.sendRedirect(redirectionUrl);
    }

    protected String buildProviderLoginUrl(HttpServletRequest request) throws UnsupportedEncodingException, MalformedURLException {
        StringBuilder originalRequestUrl = new StringBuilder(request.getRequestURL().toString());
        String originalQString = request.getQueryString();
        if (originalQString != null && originalQString.trim().length() > 0) {
            String[] params;
            boolean firstParam = true;
            for (String param : params = originalQString.split("&")) {
                String[] pair = param.split("=");
                if (NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.contains(pair[0])) continue;
                if (firstParam) {
                    originalRequestUrl.append("?");
                    firstParam = false;
                } else {
                    originalRequestUrl.append("&");
                }
                originalRequestUrl.append(param);
            }
        }
        StringBuilder str = new StringBuilder();
        URL url = new URL(originalRequestUrl.toString());
        this.logger.debug((Object)("Original Requested Login Url is : " + originalRequestUrl));
        if (!this.providerLoginUrl.contains("://")) {
            this.logger.debug((Object)("Relative Login Url is : " + this.providerLoginUrl));
            str.append(url.getProtocol()).append("://").append(url.getAuthority());
            if (!this.providerLoginUrl.startsWith("/")) {
                str.append("/");
            }
        }
        str.append(this.providerLoginUrl).append("?").append("client_id").append("=").append(URLEncoder.encode(this.clientId, "UTF-8"));
        if (this.clientSecret != null) {
            str.append("&").append(URL_PARAM_CLIENT_SECRET).append("=").append(URLEncoder.encode(this.clientSecret, "UTF-8"));
        }
        str.append("&").append(URL_PARAM_REDIRECT_URL).append("=").append(URLEncoder.encode(originalRequestUrl.toString(), "UTF-8")).append("&").append(URL_PARAM_RESPONSE_TYPE).append("=").append(this.responseType).append("&").append(URL_PARAM_SCOPE).append("=read+write").append("&").append("state").append("=").append(URLEncoder.encode(Double.toString(Math.random()), "UTF-8"));
        this.logger.debug((Object)("Provider login url is " + str.toString()));
        return str.toString();
    }

    private boolean isLogoutRequested(HttpServletRequest request, ServletResponse response) {
        String paramVal = request.getParameter("logoutsrc");
        return "logoutbutton".equalsIgnoreCase(paramVal);
    }

    protected void refreshTokenWithProvider(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug((Object)"Going to refresh token with provider");
        this.redirectUserToProviderLogin(request, response);
    }

    protected boolean redirectUserToOriginalUrl(ServletRequest request, ServletResponse response) throws IOException {
        String ref;
        String queryString;
        this.logger.debug((Object)"Redirecting user to Original Requested URL");
        String currentUrl = ((HttpServletRequest)request).getRequestURL().toString();
        URL url = new URL(currentUrl);
        StringBuilder redirectionURL = new StringBuilder();
        redirectionURL.append(url.getProtocol()).append("://").append(url.getAuthority());
        String path = url.getPath();
        if (path != null && path.trim().length() > 0) {
            redirectionURL.append(path);
        }
        if ((queryString = ((HttpServletRequest)request).getQueryString()) != null && queryString.trim().length() > 0) {
            String[] params;
            boolean firstParam = true;
            for (String param : params = queryString.split("&")) {
                String[] pair = param.split("=");
                if (NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.contains(pair[0])) continue;
                if (firstParam) {
                    redirectionURL.append("?");
                    firstParam = false;
                } else {
                    redirectionURL.append("&");
                }
                redirectionURL.append(param);
            }
        }
        if ((ref = ((HttpServletRequest)request).getParameter(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK)) != null && ref.trim().length() > 0) {
            redirectionURL.append("#").append(ref);
        }
        this.logger.debug((Object)("Original redirection URL is " + redirectionURL.toString()));
        ((HttpServletResponse)response).sendRedirect(redirectionURL.toString());
        return true;
    }

    private void logoutSSOUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug((Object)"Going to log out user from provider");
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        }
        response.sendRedirect(this.buildLogoutUrl(request));
    }

    protected String buildLogoutUrl(HttpServletRequest request) throws MalformedURLException, UnsupportedEncodingException {
        this.logger.debug((Object)("Original Requested Logout URL is " + request.getRequestURL().toString()));
        URL url = new URL(request.getRequestURL().toString());
        StringBuilder logoutUrl = new StringBuilder();
        if (!this.isAbsolute(this.providerLogoutUrl)) {
            this.logger.debug((Object)("Relative Logout Url is : " + this.providerLogoutUrl));
            logoutUrl.append(url.getProtocol()).append("://").append(url.getAuthority());
            if (!this.providerLogoutUrl.startsWith("/")) {
                logoutUrl.append("/");
            }
        }
        logoutUrl.append(this.providerLogoutUrl).append("?");
        this.appendParameter(logoutUrl, URL_PARAM_REDIRECT_URL, URLEncoder.encode(url.getProtocol() + "://" + url.getAuthority() + "/portal/", "UTF-8"));
        this.appendParameter(logoutUrl, "client_id", URLEncoder.encode(this.clientId, "UTF-8"));
        if (this.clientSecret != null) {
            this.appendParameter(logoutUrl, URL_PARAM_CLIENT_SECRET, URLEncoder.encode(this.clientSecret, "UTF-8"));
        }
        this.appendParameter(logoutUrl, URL_PARAM_RESPONSE_TYPE, this.responseType);
        this.appendParameter(logoutUrl, URL_PARAM_SCOPE, "read+write");
        this.appendParameter(logoutUrl, "state", URLEncoder.encode(Double.toString(Math.random()), "UTF-8"));
        this.logger.debug((Object)("Logout redirection URL is " + logoutUrl.toString()));
        return logoutUrl.toString();
    }

    private StringBuilder appendParameter(StringBuilder url, String name, String value) {
        char lastCharacter;
        if (url.length() > 0 && (lastCharacter = url.charAt(url.length() - 1)) != '?' && lastCharacter != '&') {
            url.append('&');
        }
        return url.append(name).append("=").append(value);
    }

    private boolean isAbsolute(String url) {
        return url.contains("://");
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    static {
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_LOGIN_TOKEN);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_TOKEN_TYPE);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_USERNAME);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add("state");
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_EXPIRES_IN);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add("client_id");
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK);
    }
}

