/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter.helper;

import com.ericsson.neptune.security.ComponentCookie;
import com.ericsson.neptune.security.ComponentPOJO;
import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.util.RestHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

public class CookieCacheManager {
    private static final String REMOTE_COMPONENT_TO_NEPTUNE = "/portal/storecookies";
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private Logger logger = Logger.getLogger(CookieCacheManager.class);
    private ConcurrentHashMap<String, Map<String, Cookie[]>> cookiesCache;
    private AuthProviderClient providerClient;
    private String neptuneBaseUrl;
    private boolean isNeptune;
    private String componentName;
    private boolean isConfigured;
    private static CookieCacheManager instance = new CookieCacheManager();

    public static CookieCacheManager getInstance() {
        return instance;
    }

    private CookieCacheManager() {
    }

    public void configure(AuthProviderClient providerClient, boolean isNeptune, String neptune_sso_webservice_url, String componentName) {
        if (this.isConfigured) {
            return;
        }
        this.isConfigured = true;
        this.providerClient = providerClient;
        this.cookiesCache = new ConcurrentHashMap();
        this.isNeptune = isNeptune;
        this.neptuneBaseUrl = this.getNeptuneBaseURL(neptune_sso_webservice_url);
        this.componentName = componentName;
    }

    public boolean storeCookieinCache(HttpServletRequest request) {
        boolean isStoreCookieCall = request.getRequestURI().contains(REMOTE_COMPONENT_TO_NEPTUNE);
        if (!isStoreCookieCall) {
            return isStoreCookieCall;
        }
        if (!this.isNeptune) {
            this.logger.error((Object)"Only a Neptune instance should be coming in this method call. Contact your technical support team.");
            return isStoreCookieCall;
        }
        String cookiesJson = "";
        try {
            String token;
            HttpSession session = request.getSession(false);
            if (session == null) {
                this.logger.error((Object)"Invalid request state - session is null or neptune principal is null in session");
                return isStoreCookieCall;
            }
            cookiesJson = this.providerClient.readRequest(request);
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, ComponentCookie[]>> jsonCookies = new TypeReference<HashMap<String, ComponentCookie[]>>(){};
            HashMap cookiesMap = (HashMap)mapper.readValue(cookiesJson.getBytes(), (TypeReference)jsonCookies);
            ComponentCookie[] compCookies = (ComponentCookie[])cookiesMap.get(token = (String)cookiesMap.keySet().iterator().next());
            if (compCookies != null) {
                Cookie[] cookies = new Cookie[compCookies.length];
                String compName = "";
                for (int idx = 0; idx < compCookies.length; ++idx) {
                    ComponentCookie cc = compCookies[idx];
                    if (compName.length() < 2 && cc.getPath() != null && cc.getPath().length() > 1) {
                        compName = cc.getPath().substring(1);
                    }
                    cookies[idx] = cc.getCookie();
                }
                Map<String, Cookie[]> compCookieMap = this.cookiesCache.get(token);
                if (compCookieMap == null) {
                    compCookieMap = new HashMap<String, Cookie[]>();
                }
                compName = compName.endsWith("/") ? compName.substring(0, compName.length() - 1) : compName;
                compCookieMap.put(compName, cookies);
                this.cookiesCache.put(token, compCookieMap);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Encountered trouble while storing cookies", (Throwable)e);
        }
        return isStoreCookieCall;
    }

    public void sendCookieJsonToNeptune(HttpServletRequest request) {
        if (this.isNeptune) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL) == null) {
            this.logger.error((Object)"Invalid request state - session is null or neptune principal is null in session");
            return;
        }
        final NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        final Cookie[] cookies = request.getCookies();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (cookies.length == 0) {
                    return;
                }
                if (CookieCacheManager.this.componentName != null) {
                    for (Cookie cookie : cookies) {
                        if (cookie.getPath() != null && cookie.getPath().length() >= 1) continue;
                        cookie.setPath("/" + CookieCacheManager.this.componentName);
                    }
                }
                HashMap<String, Cookie[]> cookiesMap = new HashMap<String, Cookie[]>();
                cookiesMap.put(principal.getToken(), cookies);
                String jsonPostData = "";
                ObjectMapper mapper = new ObjectMapper();
                try {
                    jsonPostData = mapper.writeValueAsString(cookiesMap);
                }
                catch (Exception e) {
                    CookieCacheManager.this.logger.error((Object)"Failed to convert cookies to JSON", (Throwable)e);
                }
                if (jsonPostData.length() > 0 && CookieCacheManager.this.providerClient.sendPostRequest(CookieCacheManager.this.neptuneBaseUrl, jsonPostData) < 0) {
                    CookieCacheManager.this.logger.error((Object)"Failed to send cookie info to Neptune, Single Signout will not work for this session.");
                }
            }
        });
        thread.start();
    }

    public void sendLogoutRequest(String token, HttpSession session) {
        Map<String, Cookie[]> componentCookieMap = this.cookiesCache.remove(token);
        if (componentCookieMap == null || componentCookieMap.size() == 0) {
            return;
        }
        ComponentPOJO[] components = this.getAllComponents(session);
        if (components == null || components.length == 0) {
            this.logger.warn((Object)"There are component related cookies in cache but no component records found. Check the component registration UI.");
            return;
        }
        for (ComponentPOJO component : components) {
            Cookie[] cookies = componentCookieMap.get(component.getName());
            if (cookies == null || cookies.length == 0) continue;
            RemoteComponentLogoutHelper helper = new RemoteComponentLogoutHelper(component, cookies);
            Thread t = new Thread(helper);
            t.start();
        }
    }

    private ComponentPOJO[] getAllComponents(HttpSession session) {
        ComponentPOJO[] retVal = new ComponentPOJO[]{};
        NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (principal == null) {
            return retVal;
        }
        String componentsJson = null;
        RestHelper rhelper = new RestHelper();
        try {
            String url = (String)session.getAttribute("REST_BASE_URL");
            url = url == null ? "" : url;
            componentsJson = rhelper.sendRest(url + "/cms/services/components", principal.getToken());
        }
        catch (Exception e1) {
            this.logger.error((Object)"Failed to get list of components", (Throwable)e1);
            return retVal;
        }
        return this.getComponentsFromJson(componentsJson);
    }

    private ComponentPOJO[] getComponentsFromJson(String componentsJson) {
        Map map = null;
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, ComponentPOJO[].class);
        try {
            map = (Map)mapper.readValue(componentsJson, (JavaType)mapType);
            return (ComponentPOJO[])map.get("components");
        }
        catch (Exception e1) {
            this.logger.error((Object)"Failed to unmarshall JSON", (Throwable)e1);
            return new ComponentPOJO[0];
        }
    }

    private String getNeptuneBaseURL(String url) {
        String neptuneURL = "";
        if (url != null && !url.isEmpty()) {
            String[] parts = url.split("/");
            neptuneURL = parts[0] + "//" + parts[2] + REMOTE_COMPONENT_TO_NEPTUNE;
        }
        return neptuneURL;
    }

    private class RemoteComponentLogoutHelper
    implements Runnable {
        private ComponentPOJO component;
        private Cookie[] cookies;

        public RemoteComponentLogoutHelper(ComponentPOJO component, Cookie[] cookies) {
            this.component = component;
            this.cookies = cookies;
        }

        @Override
        public void run() {
            String urlStr = this.component.getBaseURL();
            try {
                URL url = new URL(urlStr);
                String authority = url.getAuthority();
                if (urlStr.endsWith(authority)) {
                    urlStr = urlStr + "/" + this.component.getName();
                } else if (urlStr.endsWith(authority + "/")) {
                    urlStr = urlStr + this.component.getName();
                }
            }
            catch (MalformedURLException e) {
                CookieCacheManager.this.logger.warn((Object)("Component base URL for [" + this.component.getName() + "]does not appear to be a valid URL format, going to use configured base url[" + this.component.getBaseURL() + "] as it is for reference."), (Throwable)e);
            }
            urlStr = urlStr + "/logout?logoutsrc=logoutbutton";
            CookieCacheManager.this.logger.info((Object)("Remote component[" + this.component.getName() + "] logout url is: " + urlStr));
            int statusCode = CookieCacheManager.this.providerClient.logoutUser(urlStr, this.cookies);
            if (statusCode < 0) {
                CookieCacheManager.this.logger.error((Object)("Failed to perform logout at remote component " + this.component.getName()));
            } else {
                CookieCacheManager.this.logger.debug((Object)("Successfully logged out from " + this.component.getName()));
            }
        }
    }
}

