/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.AuthenticationException;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import com.ericsson.neptune.security.util.SSLUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASWebServiceAuthenticationFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_WEBSERVICE_URL = "neptune_sso_webservice_url";
    protected boolean isNeptune;

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"JBossJAASWebServiceAuthenticationFilter interrupting the request");
        if (this.isNeptune) {
            this.logger.error((Object)"Wrong filter configuration.");
            response.sendError(417, "This component is not Neptune. Wrong filter configuration.");
            return;
        }
        NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (SSLUtil.hasSSLFingerPrint(request) && principal != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader.startsWith("Basic") || authHeader.startsWith("Bearer")) {
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Request");
                throw new AuthenticationException("Principal not found in request");
            }
            WebAuthentication webAuthentication = this.getWebAuthentication();
            String password = "";
            if (authHeader.startsWith("Basic")) {
                String base64Val = authHeader.substring(6);
                String decodedVal = new String(Base64.decodeBase64((byte[])base64Val.getBytes()));
                int ColonIndex = decodedVal.indexOf(":");
                password = decodedVal.substring(ColonIndex + 1);
            }
            if (!webAuthentication.login(principal.getUserName(), (Object)password)) {
                this.logger.error((Object)"WebAuthentication login failed!");
                throw new AuthenticationException("Invalid user credentials");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected WebAuthentication getWebAuthentication() {
        return new WebAuthentication();
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
    }
}

