/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASUIFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"JBossJAASUIFilter interrupting the request");
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("webAuthentication") == null) {
            NeptunePrincipal principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session");
                throw new ServletException("Could not get Neptune Principal from Session");
            }
            String password = "";
            this.logger.debug((Object)"Calling Neptune Login module");
            this.mapSSOUserToJAASUser(session, principal.getUserName(), password);
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void mapSSOUserToJAASUser(HttpSession session, String userName, String password) {
        this.logger.debug((Object)"Calling web authentication login");
        WebAuthentication webAuthentication = new WebAuthentication();
        if (!webAuthentication.login(userName, (Object)password)) {
            this.logger.error((Object)"WebAuthentication login failed!");
            return;
        }
        session.setAttribute("webAuthentication", (Object)webAuthentication);
        session.setAttribute("username", (Object)userName);
    }
}

