/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASWebServiceAuthenticationFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_WEBSERVICE_URL = "neptune_sso_webservice_url";
    private String webserviceUrl;
    private boolean isNeptune;

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.logger.debug((Object)"JBossJAASWebServiceAuthenticationFilter interrupting the request");
        if (!this.isNeptune) {
            String authHeader = request.getHeader("Authorization");
            if (authHeader.startsWith("Basic") || authHeader.startsWith("Bearer")) {
                NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
                if (principal == null) {
                    this.logger.debug((Object)"Could not get Neptune Principal from Session");
                    response.sendError(401, "Principal not found in session");
                    return;
                }
                WebAuthentication webAuthentication = new WebAuthentication();
                String password = "";
                if (authHeader.startsWith("Basic")) {
                    String base64Val = authHeader.substring(6);
                    String decodedVal = new String(Base64.decode(base64Val));
                    int ColonIndex = decodedVal.indexOf(":");
                    password = decodedVal.substring(ColonIndex + 1);
                }
                if (!webAuthentication.login(principal.getUserName(), (Object)password)) {
                    this.logger.error((Object)"WebAuthentication login failed!");
                    response.sendError(401, "Wrong Username/Password.");
                    return;
                }
            }
        } else {
            this.logger.error((Object)"Wrong filter configuration.");
            response.sendError(417, "This component is not Neptune. Need to configure webservice url in provider_urls_remote properties file");
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.webserviceUrl = this.providerUrls.getProperty(NEPTUNE_SSO_WEBSERVICE_URL);
        if (this.webserviceUrl == null) {
            this.logger.debug((Object)"neptune_sso_webservice_url is not set. Setting it to empty");
            this.isNeptune = true;
        } else if (this.webserviceUrl.trim().isEmpty()) {
            this.logger.debug((Object)"This is neptune running the filter. DB is accessed directly.");
            this.isNeptune = true;
        } else {
            this.isNeptune = false;
        }
    }
}

