package com.tandbergtv.neptune.ui.realm.client.settings.service;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiSettingGroup implements IsSerializable {

	private static final long serialVersionUID = 1L;
	
    protected List<UiLocalizedString> displayName;
    protected List<UiSettingDefinition> settings;
    
    protected String path;
    protected String parentPath;
    
    protected List<UiSettingGroup> children;

	private boolean hasErrors;

    /*
     * Default constructor for GWT Serialization
     */
    public UiSettingGroup() {
    }
    
	public List<UiLocalizedString> getDisplayName() {
		return displayName;
	}

	public void setDisplayName(List<UiLocalizedString> displayName) {
		this.displayName = displayName;
	}

	public List<UiSettingDefinition> getSettings() {
		return settings;
	}

	public void setSettings(List<UiSettingDefinition> settings) {
		this.settings = settings;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getParentPath() {
		return parentPath;
	}

	public void setParentPath(String parentPath) {
		this.parentPath = parentPath;
	}

	public List<UiSettingGroup> getChildren() {
		if (children == null) {
			children = new ArrayList<UiSettingGroup>();
		}
		return children;
	}

	public void setChildren(List<UiSettingGroup> children) {
		this.children = children;
	}
	
	public void markHasErrors(boolean hasErrors) {
		this.hasErrors = hasErrors;
	}
	
	
	public boolean hasErrors() {
		return this.hasErrors;
	}

}
