/*
 * Created on Dec 30, 2011
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.view;

import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUserKey;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record for the user
 * 
 * @author Vijay Silva
 */
final class UserRecord implements Record<UiUserKey> {

	/* The user managed by the record */
	private final UiUser user;

	/**
	 * Constructor
	 * 
	 * @param user The external user
	 */
	public UserRecord(UiUser user) {
		this.user = user;
	}

	/**
	 * Get the key for the user
	 * 
	 * @return The external user key
	 */
	@Override
	public UiUserKey getKey() {
		return user.getKey();
	}

	/**
	 * Get the external user
	 * 
	 * @return The user
	 */
	public UiUser getUser() {
		return this.user;
	}
}
