/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link PasswordTextBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.PasswordTextBox
 * @author Vijay Silva
 */
public class PasswordTextBoxWidget extends PasswordTextBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PasswordTextBox#PasswordTextBox()
	 */
	public PasswordTextBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PasswordTextBox#PasswordTextBox()
	 */
	protected PasswordTextBoxWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.PasswordTextBox#wrap(Element)
	 */
	public static PasswordTextBoxWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		PasswordTextBoxWidget widget = new PasswordTextBoxWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
