package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public interface DetailFeature<K, R extends Record<K>> extends Feature {

	/**
	 * Builds the view for the record and provides the callback for the view to notify the feature
	 * when changes need to be made to the record
	 * 
	 * @param record The record
	 * @param callback The call back for view event notification
	 * @return The detail view
	 */
	DetailView<K, R> getView(R record, DetailViewCallback<K, R> callback);

	/**
	 * Determine if a column has a link to the detail view
	 * 
	 * @param column the table column
	 * @return true if column has link, false otherwise
	 */
	boolean hasDetailLink(Column<?, R> column);

	/**
	 * Get the record to use in order to go to the detail view for a new record (create)
	 * 
	 * @param callback The callback providing the new record
	 */
	void getNew(AsyncCallback<R> callback);

	/**
	 * Save the record updated in the detail view
	 * 
	 * @param the record to save
	 * @param callback The call back to notify on success or failure of the save
	 */
	void save(R record, AsyncCallback<Void> callback);

	/**
	 * Delete the list of records from the list view
	 * 
	 * @param the list of records to delete
	 * @param callback The call back to notify on success or failure
	 */
	void delete(List<R> records, AsyncCallback<Void> callback);

	/**
	 * Determine if the create button needs to be displayed
	 * 
	 * @return true if the create button is displayed, false otherwise
	 */
	boolean showCreateButton();

	/**
	 * Determine if the delete button needs to be displayed
	 * 
	 * @return true if the delete button is displayed, false otherwise
	 */
	boolean showDeleteButton();

	/**
	 * Get the key serializer that can be used to convert the record key to a string
	 * 
	 * @return the key serializer
	 */
	KeySerializer<K> getKeySerializer();
}
