package com.tandbergtv.neptune.widgettoolkit.client.menu;

/**
 * A menu item that triggers execution of an action without directly changing the UI. The action
 * implementation could trigger changes to the UI (indirectly). Example: Logout button.
 * 
 * @author Vijay Silva
 */
public class ActionMenuItem extends MenuItemBase {

	/* The command to execute */
	private final Runnable runnable;

	/**
	 * Constructor - Create a new action menu item with the provided name
	 * 
	 * @param name The menu item name which is also used as the display name
	 * @param runnable The command to execute when the menu item is selected / clicked
	 */
	public ActionMenuItem(String name, Runnable runnable) {
		this(name, name, runnable);
	}

	/**
	 * Constructor - Create a new action menu item with the provided name and display name
	 * 
	 * @param name The menu item name (used for anchors)
	 * @param displayName The menu item display name (displayed in the UI)
	 * @param runnable The command to execute when the menu item is selected / clicked
	 */
	public ActionMenuItem(String name, String displayName, Runnable runnable) {
		super(name, displayName);
		this.runnable = runnable;
	}

	/**
	 * Get the command executed when the the menu item is selected
	 * 
	 * @return The command to execute for the menu item
	 */
	public Runnable getRunnable() {
		return runnable;
	}

	/**
	 * Support for the visitor pattern
	 * 
	 * @param visitor The visitor
	 */
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
