/*
 * Created on May 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter;


/**
 * Service that converts a typed value to and from a string
 * 
 * @author Vijay Silva
 */
public interface IValueConverter<DataType> {

	/**
	 * Converts the string value to the typed value
	 * 
	 * @param value the string value
	 * @return The typed value
	 * @throws ValueFormatException thrown if the value displayed is not valid
	 */
	public DataType getTypedValue(String value) throws ValueFormatException;

	/**
	 * Converts the typed value to a string value that can be displayed in the UI
	 * 
	 * @param typedValue the typed value
	 * @return The string value
	 */
	public String getStringValue(DataType typedValue);
}
