/*
 * Created on May 18, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.NamedFrame;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link FormPanel} widget.
 * 
 * @see com.google.gwt.user.client.ui.FormPanel
 * @author Vijay Silva
 */
public class FormContainer extends FormPanel implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FormPanel#FormPanel()
	 */
	public FormContainer() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FormPanel#FormPanel(NamedFrame)
	 */
	public FormContainer(NamedFrame frameTarget) {
		super(frameTarget);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FormPanel#FormPanel(String)
	 */
	public FormContainer(String target) {
		super(target);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FormPanel#FormPanel(Element)
	 */
	protected FormContainer(Element element) {
		super(element);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FormPanel#FormPanel(Element, boolean)
	 */
	protected FormContainer(Element element, boolean createIFrame) {
		super(element, createIFrame);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
