package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * Defines a Column within the Table.
 * 
 * @author trybak
 * 
 * @param <A>
 *            Type of the Column, this type is what will be used by the View to
 *            set and get its value.
 * @param <R>
 *            Type of the Record.
 */
public interface Column<A, R extends Record<?>> {

	/**
	 * Programmatic name of the column. In general this should be the JPA name
	 * of the property tied to this column.
	 */
	String getName();

	/**
	 * User friendly name for this column.
	 */
	String getDisplayName();

	/**
	 * Provides a View for the cell intercept of the Column and Record.
	 * @param record record from which this column should obtain the value to be displayed in the view
	 * @return View populated with the data from record
	 */
	View<A> getView(R record);

	/**
	 * Provides a style class to associate with every data cell for the given column in the table
	 * 
	 * @return The style name
	 */
	String getCellStyle();
	
	/**
	 * Gets the column width - in pixels or percentage. Used to set the id column width
	 *  
	 * @return
	 */
	String getColumnWidth();
}
